/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.vungle;

import android.content.Context;
import android.util.Log;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.vungle.warren.InitCallback;
import com.vungle.warren.Plugin;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.error.VungleException;
import java.util.Map;

public class VungleInitManager
extends TPInitMediation {
    private static final String TAG = "Vungle";
    private String mAppId;
    private static VungleInitManager sInstance;

    public static synchronized VungleInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new VungleInitManager();
        }
        return sInstance;
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mAppId = tpParams.get("appId");
        }
        if (VungleInitManager.isInited((String)this.mAppId)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(this.mAppId, initCallback)) {
            return;
        }
        this.suportGDPR(context, userParams);
        Log.d((String)"InitNetworkSDK", (String)("initSDK: appId :" + this.mAppId));
        Plugin.addWrapperInfo((VungleApiClient.WrapperFramework)VungleApiClient.WrapperFramework.vunglehbs, (String)"13.0.0");
        Vungle.init((String)this.mAppId, (Context)context.getApplicationContext(), (InitCallback)new InitCallback(){

            public void onSuccess() {
                Log.i((String)VungleInitManager.TAG, (String)"onSuccess: ");
                VungleInitManager.this.sendResult(VungleInitManager.this.mAppId, true);
            }

            public void onError(VungleException exception) {
                if (exception != null) {
                    Log.i((String)VungleInitManager.TAG, (String)("InitCallback - onError: " + exception.getLocalizedMessage()));
                    VungleInitManager.this.sendResult(VungleInitManager.this.mAppId, false, "", exception.getLocalizedMessage());
                } else {
                    VungleInitManager.this.sendResult(VungleInitManager.this.mAppId, false, "", "");
                    Log.i((String)VungleInitManager.TAG, (String)"Throwable is null");
                }
            }

            public void onAutoCacheAdAvailable(String placementId) {
            }
        });
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("gdpr_consent") && userParams.containsKey("isue")) {
                boolean need_set_gdpr = false;
                int consent = (Integer)userParams.get("gdpr_consent");
                if (consent == 0) {
                    need_set_gdpr = true;
                }
                boolean isEu = (Boolean)userParams.get("isue");
                Log.i((String)"gdpr", (String)("suportGDPR: " + need_set_gdpr + ":isUe:" + isEu));
                Vungle.updateConsentStatus((Vungle.Consent)(need_set_gdpr ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT), (String)"1.0.0");
            }
            Log.i((String)"VungleInterstitial", (String)("suportGDPR ccpa: " + userParams.get("CCPA")));
            if (userParams.containsKey("CCPA")) {
                boolean cppa = (Boolean)userParams.get("CCPA");
                Vungle.updateCCPAStatus((Vungle.Consent)(cppa ? Vungle.Consent.OPTED_IN : Vungle.Consent.OPTED_OUT));
            }
        }
    }

    public String getNetworkVersionCode() {
        return "6.11.0";
    }

    public String getNetworkVersionName() {
        return TAG;
    }
}

