/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.tapjoy;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJPrivacyPolicy;
import com.tapjoy.Tapjoy;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import java.util.Hashtable;
import java.util.Map;

public class TapjoyInitManager
extends TPInitMediation {
    private static final String TAG = "Tapjoy";
    private String mSdkKey;
    private String userId;
    private static TapjoyInitManager sInstance;

    public static synchronized TapjoyInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new TapjoyInitManager();
        }
        return sInstance;
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        if (tpParams != null && tpParams.size() > 0) {
            this.mSdkKey = tpParams.get("Sdk_Key");
        }
        if (TapjoyInitManager.isInited((String)this.mSdkKey)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(this.mSdkKey, initCallback)) {
            return;
        }
        Hashtable<String, String> connectFlags = new Hashtable<String, String>();
        if (userParams != null && userParams.size() > 0) {
            this.userId = (String)userParams.get("user_id");
            if (TextUtils.isEmpty((CharSequence)this.userId)) {
                this.userId = "";
            }
            connectFlags.put("TJC_OPTION_USER_ID", "true");
        }
        Tapjoy.setActivity((Activity)((Activity)context));
        Tapjoy.setDebugEnabled((boolean)TestDeviceUtil.getInstance().isNeedTestDevice());
        Log.d((String)"InitNetworkSDK", (String)("initSDK: SdkKey :" + this.mSdkKey));
        Tapjoy.connect((Context)context, (String)this.mSdkKey, connectFlags, (TJConnectListener)new TJConnectListener(){

            public void onConnectFailure() {
                Log.i((String)TapjoyInitManager.TAG, (String)"onConnectFailure: ");
                TapjoyInitManager.this.sendResult(TapjoyInitManager.this.mSdkKey, false, "", "onConnectFailure");
            }

            public void onConnectSuccess() {
                TapjoyInitManager.this.sendResult(TapjoyInitManager.this.mSdkKey, true);
            }
        });
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (userParams != null && userParams.size() > 0) {
            TJPrivacyPolicy privacyPolicy = Tapjoy.getPrivacyPolicy();
            if (userParams.containsKey("gdpr_consent") && userParams.containsKey("isue")) {
                boolean need_set_gdpr = false;
                int consent1 = (Integer)userParams.get("gdpr_consent");
                if (consent1 == 0) {
                    need_set_gdpr = true;
                }
                boolean isEu = (Boolean)userParams.get("isue");
                Log.i((String)"gdpr", (String)("suportGDPR: " + need_set_gdpr + ":isUe:" + isEu));
                privacyPolicy.setSubjectToGDPR(isEu);
                String consent = need_set_gdpr ? "1" : "0";
                privacyPolicy.setUserConsent(consent);
            }
            Log.i((String)"TapJoyInterstitial", (String)("suportGDPR ccpa: " + userParams.get("CCPA") + ":COPPA:" + userParams.get("COPPA")));
            if (userParams.containsKey("COPPA")) {
                boolean coppa = (Boolean)userParams.get("COPPA");
                privacyPolicy.setBelowConsentAge(coppa);
            }
            if (userParams.containsKey("CCPA")) {
                boolean ccpa = (Boolean)userParams.get("CCPA");
                if (ccpa) {
                    privacyPolicy.setUSPrivacy("1YYY");
                } else {
                    privacyPolicy.setUSPrivacy("1YNN");
                }
            }
        }
    }

    public String getNetworkVersionCode() {
        return Tapjoy.getVersion();
    }

    public String getNetworkVersionName() {
        return TAG;
    }
}

