/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.tapjoy;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tapjoy.TJActionRequest;
import com.tapjoy.TJError;
import com.tapjoy.TJGetCurrencyBalanceListener;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.TJPrivacyPolicy;
import com.tapjoy.Tapjoy;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.tapjoy.TapjoyErrorUtil;
import com.tradplus.ads.tapjoy.TapjoyInitManager;
import com.tradplus.ads.tapjoy.TapjoyInterstitialCallbackRouter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class TapJoyInterstitialVideo
extends TPRewardAdapter {
    public static final String VIDEO_TYPE_KEY = "vedioType";
    public static final String CURRENCY_NAME_KEY = "currencyName";
    public static final String AMOUNT_KEY = "amount";
    public static final String PASS_SCAN_KEY = "passScan";
    private WeakReference<Context> contextWeakReference;
    private long mAdLoadTimeStamp;
    private String mAdUnitId;
    private String mParams;
    private String appId;
    private String placementId;
    private String mVideoType;
    private String mCurrencyName;
    private String mAmount;
    private String mPassScan;
    private String mSdkKey;
    private String payload;
    private TJPlacement mPlacement;
    private TJPlacement examplePlacement;
    private TapjoyInterstitialCallbackRouter tapjoyInterstitialCallbackRouter;
    TJPlacementListener placementListener = new TJPlacementListener(){

        public void onRequestSuccess(TJPlacement tjPlacement) {
            if (!tjPlacement.isContentAvailable()) {
                Log.d((String)"TradPlus", (String)("Tapjoy request call failed\uff0cthe placementId is " + TapJoyInterstitialVideo.this.placementId));
                if (TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()) != null) {
                    TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()).loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                }
            }
        }

        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            Log.d((String)"TradPlus", (String)("Tapjoy request call failed\uff0cthe placementId is " + TapJoyInterstitialVideo.this.placementId));
            if (TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()) != null) {
                TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()).loadAdapterLoadFailed(TapjoyErrorUtil.getTradPlusErrorCode("Third-party network failed to provide an ad.", tjError));
            }
        }

        public void onContentReady(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Tapjoy rewardedvideo ad loaded successfully\uff0cthe placementId is " + TapJoyInterstitialVideo.this.placementId));
            if (TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()) != null) {
                TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()).loadAdapterLoaded(null);
            }
        }

        public void onContentShow(TJPlacement tjPlacement) {
        }

        public void onContentDismiss(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Tapjoy rewardedvideo ad closed\uff0cthe placementId is " + TapJoyInterstitialVideo.this.placementId));
            if (TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()) != null) {
                TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()).onAdClosed();
            }
        }

        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
        }

        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
        }

        public void onClick(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Tapjoy rewardedvideo ad clicked\uff0cthe placementId is " + TapJoyInterstitialVideo.this.placementId));
            if (TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()) != null) {
                TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()).onAdClicked();
            }
        }
    };
    TJPlacementVideoListener placementVideoListener = new TJPlacementVideoListener(){

        public void onVideoComplete(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Tapjoy rewardedvideo ad onVideoComplete\uff0cthe placementId is " + TapJoyInterstitialVideo.this.placementId));
            if (TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(TapJoyInterstitialVideo.this.placementId) != null) {
                TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(TapJoyInterstitialVideo.this.placementId).onReward();
            }
            Tapjoy.getCurrencyBalance((TJGetCurrencyBalanceListener)new TJGetCurrencyBalanceListener(){

                public void onGetCurrencyBalanceResponse(String s, int i) {
                }

                public void onGetCurrencyBalanceResponseFailure(String s) {
                }
            });
        }

        public void onVideoError(TJPlacement tjPlacement, String s) {
            Log.d((String)"TradPlus", (String)("TJPlacement:" + tjPlacement.getName() + " , Error :" + s));
        }

        public void onVideoStart(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Showing TJPlacement interstitial ad, the TJPlacement is " + tjPlacement.getName()));
            if (TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()) != null) {
                TapJoyInterstitialVideo.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()).onAdShown();
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.tapjoyInterstitialCallbackRouter = TapjoyInterstitialCallbackRouter.getInstance();
        this.mAdLoadTimeStamp = System.currentTimeMillis();
        if (!this.extrasAreValid(serverExtras)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.appId = serverExtras.get("appId");
        this.placementId = serverExtras.get("placementId");
        this.mVideoType = serverExtras.get(VIDEO_TYPE_KEY);
        this.mCurrencyName = serverExtras.get(CURRENCY_NAME_KEY);
        this.mAmount = serverExtras.get(AMOUNT_KEY);
        this.mPassScan = serverExtras.get(PASS_SCAN_KEY);
        this.mSdkKey = serverExtras.get("Sdk_Key");
        this.mAdUnitId = (String)localExtras.get("com_tp_ad_unit_id");
        this.payload = (String)localExtras.get("Bidding-Payload");
        this.mParams = serverExtras.toString();
        this.tapjoyInterstitialCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        if (!Tapjoy.isConnected()) {
            TapjoyInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    TapJoyInterstitialVideo.this.load();
                }

                public void onFailed(String code, String msg) {
                    if (TapJoyInterstitialVideo.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        TapJoyInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.load();
        }
    }

    private void load() {
        this.mPlacement = Tapjoy.getPlacement((String)this.placementId, (TJPlacementListener)this.placementListener);
        this.mPlacement.setVideoListener(this.placementVideoListener);
        if (TextUtils.isEmpty((CharSequence)this.payload)) {
            LogUtil.ownShow((String)"normal load");
        } else {
            LogUtil.ownShow((String)"bidding load");
            HashMap<String, String> auctionData = new HashMap<String, String>();
            try {
                JSONObject main = new JSONObject(this.payload);
                String id = main.getString("id");
                String extData = main.getString("ext_data");
                auctionData.put("id", id);
                auctionData.put("ext_data", extData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPlacement.setAuctionData(auctionData);
        }
        this.mPlacement.requestContent();
    }

    private void suportGDPR(Context context, Map<String, Object> localExtras) {
        if (localExtras != null && localExtras.size() > 0) {
            TJPrivacyPolicy privacyPolicy = Tapjoy.getPrivacyPolicy();
            if (localExtras.containsKey("gdpr_consent") && localExtras.containsKey("isue")) {
                boolean need_set_gdpr = false;
                int consent1 = (Integer)localExtras.get("gdpr_consent");
                if (consent1 == 0) {
                    need_set_gdpr = true;
                }
                boolean isEu = (Boolean)localExtras.get("isue");
                Log.i((String)"gdpr", (String)("suportGDPR: " + need_set_gdpr + ":isUe:" + isEu));
                privacyPolicy.setSubjectToGDPR(isEu);
                String consent = need_set_gdpr ? "1" : "0";
                privacyPolicy.setUserConsent(consent);
            }
            Log.i((String)"TapJoyInterstitialVideo", (String)("suportGDPR ccpa: " + localExtras.get("CCPA") + ":COPPA:" + localExtras.get("COPPA")));
            if (localExtras.containsKey("COPPA")) {
                boolean coppa = (Boolean)localExtras.get("COPPA");
                privacyPolicy.setBelowConsentAge(coppa);
            }
            if (localExtras.containsKey("CCPA")) {
                boolean ccpa = (Boolean)localExtras.get("CCPA");
                if (ccpa) {
                    privacyPolicy.setUSPrivacy("1YYY");
                } else {
                    privacyPolicy.setUSPrivacy("1YNN");
                }
            }
        }
    }

    public void showAd() {
        if (this.tapjoyInterstitialCallbackRouter != null && this.mShowListener != null) {
            this.tapjoyInterstitialCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if (this.mPlacement != null) {
            this.mPlacement.showContent();
        } else if (this.tapjoyInterstitialCallbackRouter.getShowListener(this.placementId) != null) {
            this.tapjoyInterstitialCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
        }
    }

    public boolean isReady() {
        if (this.mPlacement == null) {
            return false;
        }
        return this.mPlacement.isContentAvailable() && !this.isAdsTimeOut();
    }

    public void clean() {
        if (this.mPlacement != null) {
            this.mPlacement.setVideoListener(null);
            this.mPlacement = null;
        }
        if (this.placementId != null) {
            this.tapjoyInterstitialCallbackRouter.removeListeners(this.placementId);
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId") && serverExtras.containsKey("placementId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("6");
    }

    public String getNetworkVersion() {
        return Tapjoy.getVersion();
    }
}

