/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.tapjoy;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tapjoy.TJActionRequest;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.Tapjoy;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.tapjoy.TapjoyErrorUtil;
import com.tradplus.ads.tapjoy.TapjoyInitManager;
import com.tradplus.ads.tapjoy.TapjoyInterstitialCallbackRouter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.json.JSONObject;

public class TapJoyInterstitial
extends TPInterstitialAdapter {
    public static final String VIDEO_TYPE_KEY = "vedioType";
    public static final String CURRENCY_NAME_KEY = "currencyName";
    public static final String AMOUNT_KEY = "amount";
    public static final String PASS_SCAN_KEY = "passScan";
    private WeakReference<Context> contextWeakReference;
    private long mAdLoadTimeStamp;
    private String mAdUnitId;
    private String mParams;
    private String appId;
    private String placementId;
    private String mVideoType;
    private String mCurrencyName;
    private String mAmount;
    private String mPassScan;
    private String mSdkKey;
    private String payload;
    private TJPlacement mPlacement;
    private TJPlacement examplePlacement;
    private TapjoyInterstitialCallbackRouter tapjoyInterstitialCallbackRouter;
    TJPlacementListener placementListener = new TJPlacementListener(){

        public void onRequestSuccess(TJPlacement tjPlacement) {
            if (!tjPlacement.isContentAvailable()) {
                Log.d((String)"TradPlus", (String)("Tapjoy request call failed\uff0cthe placementId is " + TapJoyInterstitial.this.placementId));
                if (TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()) != null) {
                    TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()).loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                }
            }
        }

        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            Log.d((String)"TradPlus", (String)("Tapjoy request call failed\uff0cthe placementId is " + TapJoyInterstitial.this.placementId));
            if (TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()) != null) {
                TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()).loadAdapterLoadFailed(TapjoyErrorUtil.getTradPlusErrorCode("Third-party network failed to provide an ad.", tjError));
            }
        }

        public void onContentReady(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Tapjoy interstitial ad loaded successfully\uff0cthe placementId is " + TapJoyInterstitial.this.placementId));
            if (TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()) != null) {
                TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getListener(tjPlacement.getName()).loadAdapterLoaded(null);
            }
        }

        public void onContentShow(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Showing Tapjoy interstitial ad\uff0cthe placementId is " + TapJoyInterstitial.this.placementId));
            if (TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()) != null) {
                TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()).onAdShown();
            }
        }

        public void onContentDismiss(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Tapjoy interstitial ad closed\uff0cthe placementId is " + TapJoyInterstitial.this.placementId));
            if (TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()) != null) {
                TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()).onAdClosed();
            }
        }

        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
        }

        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
        }

        public void onClick(TJPlacement tjPlacement) {
            Log.d((String)"TradPlus", (String)("Tapjoy interstitial ad clicked\uff0cthe placementId is " + TapJoyInterstitial.this.placementId));
            if (TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()) != null) {
                TapJoyInterstitial.this.tapjoyInterstitialCallbackRouter.getShowListener(tjPlacement.getName()).onAdClicked();
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.mAdLoadTimeStamp = System.currentTimeMillis();
        if (!this.extrasAreValid(serverExtras)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.appId = serverExtras.get("appId");
        this.placementId = serverExtras.get("placementId");
        this.mVideoType = serverExtras.get(VIDEO_TYPE_KEY);
        this.mCurrencyName = serverExtras.get(CURRENCY_NAME_KEY);
        this.mAmount = serverExtras.get(AMOUNT_KEY);
        this.mPassScan = serverExtras.get(PASS_SCAN_KEY);
        this.mSdkKey = serverExtras.get("Sdk_Key");
        this.mAdUnitId = (String)localExtras.get("com_tp_ad_unit_id");
        this.payload = (String)localExtras.get("Bidding-Payload");
        this.mParams = serverExtras.toString();
        this.tapjoyInterstitialCallbackRouter = TapjoyInterstitialCallbackRouter.getInstance();
        this.tapjoyInterstitialCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        Hashtable<String, String> connectFlags = new Hashtable<String, String>();
        connectFlags.put("TJC_OPTION_USER_ID", "true");
        if (!Tapjoy.isConnected()) {
            TapjoyInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    TapJoyInterstitial.this.requestAd();
                }

                public void onFailed(String code, String msg) {
                    if (TapJoyInterstitial.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        TapJoyInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.requestAd();
        }
    }

    private void requestAd() {
        this.mPlacement = Tapjoy.getPlacement((String)this.placementId, (TJPlacementListener)this.placementListener);
        if (!TextUtils.isEmpty((CharSequence)this.payload)) {
            HashMap<String, String> auctionData = new HashMap<String, String>();
            try {
                JSONObject main = new JSONObject(this.payload);
                String id = main.getString("id");
                String extData = main.getString("ext_data");
                auctionData.put("id", id);
                auctionData.put("ext_data", extData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPlacement.setAuctionData(auctionData);
        }
        this.mPlacement.requestContent();
    }

    public void showAd() {
        if (this.tapjoyInterstitialCallbackRouter != null && this.mShowListener != null) {
            this.tapjoyInterstitialCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if (this.mPlacement != null) {
            this.mPlacement.showContent();
        } else if (this.tapjoyInterstitialCallbackRouter.getShowListener(this.placementId) != null) {
            this.tapjoyInterstitialCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
        }
    }

    public boolean isReady() {
        if (this.mPlacement == null) {
            return false;
        }
        return this.mPlacement.isContentAvailable() && !this.isAdsTimeOut();
    }

    public void clean() {
        if (this.mPlacement != null) {
            this.mPlacement.setVideoListener(null);
            this.mPlacement = null;
        }
        if (this.placementId != null) {
            this.tapjoyInterstitialCallbackRouter.removeListeners(this.placementId);
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId") && serverExtras.containsKey("placementId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("6");
    }

    public String getNetworkVersion() {
        return Tapjoy.getVersion();
    }
}

