/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley;

import android.net.TrafficStats;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.Network;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.ResponseDelivery;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.VolleyLog;
import java.util.concurrent.BlockingQueue;

public class NetworkDispatcher
extends Thread {
    private final BlockingQueue<Request<?>> a;
    private final Network b;
    private final Cache c;
    private final ResponseDelivery d;
    private volatile boolean e = false;

    public NetworkDispatcher(BlockingQueue<Request<?>> blockingQueue, Network network, Cache cache, ResponseDelivery responseDelivery) {
        this.a = blockingQueue;
        this.b = network;
        this.c = cache;
        this.d = responseDelivery;
    }

    public void quit() {
        this.e = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            Response<?> response;
            Request<?> request;
            long l2 = SystemClock.elapsedRealtime();
            try {
                request = this.a.take();
            }
            catch (InterruptedException interruptedException) {
                if (!this.e) continue;
                return;
            }
            try {
                request.addMarker("network-queue-take");
                if (request.isCanceled()) {
                    request.a("network-discard-cancelled");
                    continue;
                }
                response = request;
                if (Build.VERSION.SDK_INT >= 14) {
                    TrafficStats.setThreadStatsTag((int)((Request)((Object)response)).getTrafficStatsTag());
                }
                response = this.b.performRequest(request);
                request.addMarker("network-http-complete");
                if (((NetworkResponse)((Object)response)).notModified && request.hasHadResponseDelivered()) {
                    request.a("not-modified");
                    continue;
                }
                response = request.parseNetworkResponse((NetworkResponse)((Object)response));
                request.addMarker("network-parse-complete");
                if (request.shouldCache() && response.cacheEntry != null) {
                    this.c.put(request.getCacheKey(), response.cacheEntry);
                    request.addMarker("network-cache-written");
                }
                request.markDelivered();
                this.d.postResponse(request, response);
                continue;
            }
            catch (VolleyError volleyError) {
                response = volleyError;
                volleyError.a = SystemClock.elapsedRealtime() - l2;
                Response<?> response2 = response;
                Request<?> request2 = request;
                response = this;
                response2 = request2.parseNetworkError((VolleyError)((Object)response2));
                ((NetworkDispatcher)((Object)response)).d.postError(request2, (VolleyError)((Object)response2));
                continue;
            }
            catch (Exception exception) {
                response = exception;
                VolleyLog.e(exception, "Unhandled exception %s", ((Throwable)((Object)response)).toString());
                response = new VolleyError((Throwable)((Object)response));
                v3.a = SystemClock.elapsedRealtime() - l2;
                this.d.postError(request, (VolleyError)((Object)response));
                continue;
            }
            break;
        }
    }
}

