/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Properties;

public class IOUtils {
    public static final String FASTJSON_PROPERTIES = "fastjson.properties";
    public static final String FASTJSON_COMPATIBLEWITHJAVABEAN = "fastjson.compatibleWithJavaBean";
    public static final String FASTJSON_COMPATIBLEWITHFIELDNAME = "fastjson.compatibleWithFieldName";
    public static final Properties DEFAULT_PROPERTIES;
    public static final Charset UTF8;
    public static final char[] DIGITS;
    public static final boolean[] firstIdentifierFlags;
    public static final boolean[] identifierFlags;
    public static final byte[] specicalFlags_doubleQuotes;
    public static final byte[] specicalFlags_singleQuotes;
    public static final boolean[] specicalFlags_doubleQuotesFlags;
    public static final boolean[] specicalFlags_singleQuotesFlags;
    public static final char[] replaceChars;
    public static final char[] ASCII_CHARS;
    static final char[] a;
    static final char[] b;
    static final char[] c;
    static final int[] d;
    public static final char[] CA;
    public static final int[] IA;

    public static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        if (string2 == null) {
            return DEFAULT_PROPERTIES.getProperty(string);
        }
        return string2;
    }

    public static void loadPropertiesFromFile() {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public final InputStream run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
                }
                return ClassLoader.getSystemResourceAsStream(IOUtils.FASTJSON_PROPERTIES);
            }
        });
        if (inputStream != null) {
            try {
                DEFAULT_PROPERTIES.load(inputStream);
                inputStream.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static int stringSize(long l2) {
        long l3 = 10L;
        for (int i2 = 1; i2 < 19; ++i2) {
            if (l2 < l3) {
                return i2;
            }
            l3 = 10L * l3;
        }
        return 19;
    }

    public static void getChars(long l2, int n2, char[] cArray) {
        int n3;
        int n4 = n2;
        int n5 = 0;
        if (l2 < 0L) {
            n5 = 45;
            l2 = -l2;
        }
        while (l2 > Integer.MAX_VALUE) {
            long l3 = l2 / 100L;
            n2 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
            l2 = l3;
            cArray[--n4] = c[n2];
            cArray[--n4] = b[n2];
        }
        int n6 = (int)l2;
        while (n6 >= 65536) {
            int n7 = n6 / 100;
            n2 = n6 - ((n7 << 6) + (n7 << 5) + (n7 << 2));
            n6 = n7;
            cArray[--n4] = c[n2];
            cArray[--n4] = b[n2];
        }
        do {
            n3 = n6 * 52429 >>> 19;
            n2 = n6 - ((n3 << 3) + (n3 << 1));
            cArray[--n4] = a[n2];
        } while ((n6 = n3) != 0);
        if (n5 != 0) {
            cArray[--n4] = n5;
        }
    }

    public static void getChars(int n2, int n3, char[] cArray) {
        int n4;
        int n5 = n3;
        int n6 = 0;
        if (n2 < 0) {
            n6 = 45;
            n2 = -n2;
        }
        while (n2 >= 65536) {
            n3 = n2 / 100;
            n4 = n2 - ((n3 << 6) + (n3 << 5) + (n3 << 2));
            n2 = n3;
            cArray[--n5] = c[n4];
            cArray[--n5] = b[n4];
        }
        do {
            n3 = n2 * 52429 >>> 19;
            n4 = n2 - ((n3 << 3) + (n3 << 1));
            cArray[--n5] = a[n4];
        } while ((n2 = n3) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    public static void getChars(byte by, int n2, char[] cArray) {
        byte by2 = by;
        int n3 = n2;
        int n4 = 0;
        if (by < 0) {
            n4 = 45;
            by2 = -by;
        }
        do {
            by = (byte)(by2 * 52429 >>> 19);
            n2 = by2 - ((by << 3) + (by << 1));
            cArray[--n3] = a[n2];
        } while ((by2 = by) != 0);
        if (n4 != 0) {
            cArray[--n3] = n4;
        }
    }

    public static int stringSize(int n2) {
        int n3 = 0;
        while (n2 > d[n3]) {
            ++n3;
        }
        return n3 + 1;
    }

    public static void decode(CharsetDecoder charsetDecoder, ByteBuffer object, CharBuffer charBuffer) {
        try {
            object = charsetDecoder.decode((ByteBuffer)object, charBuffer, true);
            if (!((CoderResult)object).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            if (!((CoderResult)(object = charsetDecoder.flush(charBuffer))).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            return;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new JSONException("utf8 decode error, " + characterCodingException.getMessage(), characterCodingException);
        }
    }

    public static boolean firstIdentifier(char c2) {
        return c2 < firstIdentifierFlags.length && firstIdentifierFlags[c2];
    }

    public static boolean isIdent(char c2) {
        return c2 < identifierFlags.length && identifierFlags[c2];
    }

    public static byte[] decodeBase64(char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = n2;
        n2 = n2 + n3 - 1;
        while (n4 < n2 && IA[cArray[n4]] < 0) {
            ++n4;
        }
        while (n2 > 0 && IA[cArray[n2]] < 0) {
            --n2;
        }
        int n5 = cArray[n2] == '=' ? (cArray[n2 - 1] == '=' ? 2 : 1) : 0;
        int n6 = n2 - n4 + 1;
        n3 = n3 > 76 ? (cArray[76] == '\r' ? n6 / 78 : 0) << 1 : 0;
        n6 = ((n6 - n3) * 6 >> 3) - n5;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        int n9 = n6 / 3 * 3;
        while (n7 < n9) {
            int n10 = IA[cArray[n4++]] << 18 | IA[cArray[n4++]] << 12 | IA[cArray[n4++]] << 6 | IA[cArray[n4++]];
            byArray[n7++] = (byte)(n10 >> 16);
            byArray[n7++] = (byte)(n10 >> 8);
            byArray[n7++] = (byte)n10;
            if (n3 <= 0 || ++n8 != 19) continue;
            n4 += 2;
            n8 = 0;
        }
        if (n7 < n6) {
            n8 = 0;
            n9 = 0;
            while (n4 <= n2 - n5) {
                n8 |= IA[cArray[n4++]] << 18 - n9 * 6;
                ++n9;
            }
            n9 = 16;
            while (n7 < n6) {
                byArray[n7++] = (byte)(n8 >> n9);
                n9 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] decodeBase64(String string, int n2, int n3) {
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = n2;
        n2 = n2 + n3 - 1;
        while (n4 < n2 && IA[string.charAt(n4)] < 0) {
            ++n4;
        }
        while (n2 > 0 && IA[string.charAt(n2)] < 0) {
            --n2;
        }
        int n5 = string.charAt(n2) == '=' ? (string.charAt(n2 - 1) == '=' ? 2 : 1) : 0;
        int n6 = n2 - n4 + 1;
        n3 = n3 > 76 ? (string.charAt(76) == '\r' ? n6 / 78 : 0) << 1 : 0;
        n6 = ((n6 - n3) * 6 >> 3) - n5;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        int n9 = n6 / 3 * 3;
        while (n7 < n9) {
            int n10 = IA[string.charAt(n4++)] << 18 | IA[string.charAt(n4++)] << 12 | IA[string.charAt(n4++)] << 6 | IA[string.charAt(n4++)];
            byArray[n7++] = (byte)(n10 >> 16);
            byArray[n7++] = (byte)(n10 >> 8);
            byArray[n7++] = (byte)n10;
            if (n3 <= 0 || ++n8 != 19) continue;
            n4 += 2;
            n8 = 0;
        }
        if (n7 < n6) {
            n8 = 0;
            n9 = 0;
            while (n4 <= n2 - n5) {
                n8 |= IA[string.charAt(n4++)] << 18 - n9 * 6;
                ++n9;
            }
            n9 = 16;
            while (n7 < n6) {
                byArray[n7++] = (byte)(n8 >> n9);
                n9 -= 8;
            }
        }
        return byArray;
    }

    public static byte[] decodeBase64(String string) {
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4 && IA[string.charAt(n2) & 0xFF] < 0; ++n2) {
        }
        while (n4 > 0 && IA[string.charAt(n4) & 0xFF] < 0) {
            --n4;
        }
        int n5 = string.charAt(n4) == '=' ? (string.charAt(n4 - 1) == '=' ? 2 : 1) : 0;
        int n6 = n4 - n2 + 1;
        n3 = n3 > 76 ? (string.charAt(76) == '\r' ? n6 / 78 : 0) << 1 : 0;
        n6 = ((n6 - n3) * 6 >> 3) - n5;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        int n9 = n6 / 3 * 3;
        while (n7 < n9) {
            int n10 = IA[string.charAt(n2++)] << 18 | IA[string.charAt(n2++)] << 12 | IA[string.charAt(n2++)] << 6 | IA[string.charAt(n2++)];
            byArray[n7++] = (byte)(n10 >> 16);
            byArray[n7++] = (byte)(n10 >> 8);
            byArray[n7++] = (byte)n10;
            if (n3 <= 0 || ++n8 != 19) continue;
            n2 += 2;
            n8 = 0;
        }
        if (n7 < n6) {
            n8 = 0;
            n9 = 0;
            while (n2 <= n4 - n5) {
                n8 |= IA[string.charAt(n2++)] << 18 - n9 * 6;
                ++n9;
            }
            n9 = 16;
            while (n7 < n6) {
                byArray[n7++] = (byte)(n8 >> n9);
                n9 -= 8;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int encodeUTF8(char[] cArray, int n2, int n3, byte[] byArray) {
        int n4 = n2 + n3;
        int n5 = 0;
        n3 = 0 + Math.min(n3, byArray.length);
        while (n5 < n3 && cArray[n2] < '\u0080') {
            byArray[n5++] = (byte)cArray[n2++];
        }
        while (true) {
            block12: {
                block11: {
                    block13: {
                        if (n2 >= n4) {
                            return n5;
                        }
                        if ((n3 = cArray[n2++]) < 128) {
                            byArray[n5++] = (byte)n3;
                            continue;
                        }
                        if (n3 < 2048) {
                            byArray[n5++] = (byte)(0xC0 | n3 >> 6);
                            byArray[n5++] = (byte)(0x80 | n3 & 0x3F);
                            continue;
                        }
                        if (n3 < 55296 || n3 >= 57344) break block12;
                        int n6 = n2 - 1;
                        if (n3 < 55296 || n3 >= 56320) break block13;
                        if (n4 - n6 < 2) {
                            n3 = -1;
                            break block11;
                        } else if ((n6 = cArray[n6 + 1]) >= 56320 && n6 < 57344) {
                            n3 = (n3 << 10) + n6 + -56613888;
                            break block11;
                        } else {
                            byArray[n5++] = 63;
                            continue;
                        }
                    }
                    if (n3 >= 56320 && n3 < 57344) {
                        byArray[n5++] = 63;
                        continue;
                    }
                }
                if (n3 < 0) {
                    byArray[n5++] = 63;
                    continue;
                }
                byArray[n5++] = (byte)(0xF0 | n3 >> 18);
                byArray[n5++] = (byte)(0x80 | n3 >> 12 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                byArray[n5++] = (byte)(0x80 | n3 & 0x3F);
                ++n2;
                continue;
            }
            byArray[n5++] = (byte)(0xE0 | n3 >> 12);
            byArray[n5++] = (byte)(0x80 | n3 >> 6 & 0x3F);
            byArray[n5++] = (byte)(0x80 | n3 & 0x3F);
        }
    }

    public static int decodeUTF8(byte[] byArray, int n2, int n3, char[] cArray) {
        int n4 = n2 + n3;
        int n5 = 0;
        n3 = Math.min(n3, cArray.length);
        while (n5 < n3 && byArray[n2] >= 0) {
            cArray[n5++] = (char)byArray[n2++];
        }
        while (n2 < n4) {
            char c2;
            byte by;
            byte by2;
            if ((n3 = byArray[n2++]) >= 0) {
                cArray[n5++] = (char)n3;
                continue;
            }
            if (n3 >> 5 == -2 && (n3 & 0x1E) != 0) {
                if (n2 < n4) {
                    if (((by2 = byArray[n2++]) & 0xC0) != 128) {
                        return -1;
                    }
                    cArray[n5++] = (char)(n3 << 6 ^ by2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (n3 >> 4 == -2) {
                if (n2 + 1 < n4) {
                    by2 = byArray[n2++];
                    by = byArray[n2++];
                    if (n3 == -32 && (by2 & 0xE0) == 128 || (by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                        return -1;
                    }
                    c2 = (char)(n3 << 12 ^ by2 << 6 ^ (by ^ 0xFFFE1F80));
                    if (c2 >= '\ud800' && c2 < '\ue000') {
                        return -1;
                    }
                    cArray[n5++] = c2;
                    continue;
                }
                return -1;
            }
            if (n3 >> 3 == -2) {
                if (n2 + 2 < n4) {
                    by2 = byArray[n2++];
                    by = byArray[n2++];
                    c2 = byArray[n2++];
                    n3 = n3 << 18 ^ by2 << 12 ^ by << 6 ^ (c2 ^ 0x381F80);
                    if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128 || (c2 & 0xC0) != 128 || n3 < 65536 || n3 >= 0x110000) {
                        return -1;
                    }
                    cArray[n5++] = (char)((n3 >>> 10) + 55232);
                    cArray[n5++] = (char)((n3 & 0x3FF) + 56320);
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return n5;
    }

    public static String readAll(Reader reader) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n2;
            char[] cArray = new char[2048];
            while ((n2 = reader.read(cArray, 0, 2048)) >= 0) {
                stringBuilder.append(cArray, 0, n2);
            }
        }
        catch (Exception exception) {
            throw new JSONException("read string from reader error", exception);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidJsonpQueryParam(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.' || IOUtils.isIdent(c2)) continue;
            return false;
        }
        return true;
    }

    static {
        int n2;
        DEFAULT_PROPERTIES = new Properties();
        UTF8 = Charset.forName("UTF-8");
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        firstIdentifierFlags = new boolean[256];
        identifierFlags = new boolean[256];
        for (n2 = 0; n2 < firstIdentifierFlags.length; n2 = (int)((char)(n2 + 1))) {
            if (!(n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122 || n2 == 95) && n2 != 36) continue;
            IOUtils.firstIdentifierFlags[n2] = true;
        }
        for (n2 = 0; n2 < identifierFlags.length; n2 = (int)((char)(n2 + 1))) {
            if (n2 >= 65 && n2 <= 90) {
                IOUtils.identifierFlags[n2] = true;
                continue;
            }
            if (n2 >= 97 && n2 <= 122) {
                IOUtils.identifierFlags[n2] = true;
                continue;
            }
            if (n2 == 95) {
                IOUtils.identifierFlags[n2] = true;
                continue;
            }
            if (n2 < 48 || n2 > 57) continue;
            IOUtils.identifierFlags[n2] = true;
        }
        try {
            IOUtils.loadPropertiesFromFile();
        }
        catch (Throwable throwable) {}
        specicalFlags_doubleQuotes = new byte[161];
        specicalFlags_singleQuotes = new byte[161];
        specicalFlags_doubleQuotesFlags = new boolean[161];
        specicalFlags_singleQuotesFlags = new boolean[161];
        replaceChars = new char[93];
        IOUtils.specicalFlags_doubleQuotes[0] = 4;
        IOUtils.specicalFlags_doubleQuotes[1] = 4;
        IOUtils.specicalFlags_doubleQuotes[2] = 4;
        IOUtils.specicalFlags_doubleQuotes[3] = 4;
        IOUtils.specicalFlags_doubleQuotes[4] = 4;
        IOUtils.specicalFlags_doubleQuotes[5] = 4;
        IOUtils.specicalFlags_doubleQuotes[6] = 4;
        IOUtils.specicalFlags_doubleQuotes[7] = 4;
        IOUtils.specicalFlags_doubleQuotes[8] = 1;
        IOUtils.specicalFlags_doubleQuotes[9] = 1;
        IOUtils.specicalFlags_doubleQuotes[10] = 1;
        IOUtils.specicalFlags_doubleQuotes[11] = 4;
        IOUtils.specicalFlags_doubleQuotes[12] = 1;
        IOUtils.specicalFlags_doubleQuotes[13] = 1;
        IOUtils.specicalFlags_doubleQuotes[34] = 1;
        IOUtils.specicalFlags_doubleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[0] = 4;
        IOUtils.specicalFlags_singleQuotes[1] = 4;
        IOUtils.specicalFlags_singleQuotes[2] = 4;
        IOUtils.specicalFlags_singleQuotes[3] = 4;
        IOUtils.specicalFlags_singleQuotes[4] = 4;
        IOUtils.specicalFlags_singleQuotes[5] = 4;
        IOUtils.specicalFlags_singleQuotes[6] = 4;
        IOUtils.specicalFlags_singleQuotes[7] = 4;
        IOUtils.specicalFlags_singleQuotes[8] = 1;
        IOUtils.specicalFlags_singleQuotes[9] = 1;
        IOUtils.specicalFlags_singleQuotes[10] = 1;
        IOUtils.specicalFlags_singleQuotes[11] = 4;
        IOUtils.specicalFlags_singleQuotes[12] = 1;
        IOUtils.specicalFlags_singleQuotes[13] = 1;
        IOUtils.specicalFlags_singleQuotes[92] = 1;
        IOUtils.specicalFlags_singleQuotes[39] = 1;
        for (n2 = 14; n2 <= 31; ++n2) {
            IOUtils.specicalFlags_doubleQuotes[n2] = 4;
            IOUtils.specicalFlags_singleQuotes[n2] = 4;
        }
        for (n2 = 127; n2 < 160; ++n2) {
            IOUtils.specicalFlags_doubleQuotes[n2] = 4;
            IOUtils.specicalFlags_singleQuotes[n2] = 4;
        }
        for (n2 = 0; n2 < 161; ++n2) {
            IOUtils.specicalFlags_doubleQuotesFlags[n2] = specicalFlags_doubleQuotes[n2] != 0;
            IOUtils.specicalFlags_singleQuotesFlags[n2] = specicalFlags_singleQuotes[n2] != 0;
        }
        IOUtils.replaceChars[0] = 48;
        IOUtils.replaceChars[1] = 49;
        IOUtils.replaceChars[2] = 50;
        IOUtils.replaceChars[3] = 51;
        IOUtils.replaceChars[4] = 52;
        IOUtils.replaceChars[5] = 53;
        IOUtils.replaceChars[6] = 54;
        IOUtils.replaceChars[7] = 55;
        IOUtils.replaceChars[8] = 98;
        IOUtils.replaceChars[9] = 116;
        IOUtils.replaceChars[10] = 110;
        IOUtils.replaceChars[11] = 118;
        IOUtils.replaceChars[12] = 102;
        IOUtils.replaceChars[13] = 114;
        IOUtils.replaceChars[34] = 34;
        IOUtils.replaceChars[39] = 39;
        IOUtils.replaceChars[47] = 47;
        IOUtils.replaceChars[92] = 92;
        ASCII_CHARS = new char[]{'0', '0', '0', '1', '0', '2', '0', '3', '0', '4', '0', '5', '0', '6', '0', '7', '0', '8', '0', '9', '0', 'A', '0', 'B', '0', 'C', '0', 'D', '0', 'E', '0', 'F', '1', '0', '1', '1', '1', '2', '1', '3', '1', '4', '1', '5', '1', '6', '1', '7', '1', '8', '1', '9', '1', 'A', '1', 'B', '1', 'C', '1', 'D', '1', 'E', '1', 'F', '2', '0', '2', '1', '2', '2', '2', '3', '2', '4', '2', '5', '2', '6', '2', '7', '2', '8', '2', '9', '2', 'A', '2', 'B', '2', 'C', '2', 'D', '2', 'E', '2', 'F'};
        a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        b = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        c = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        d = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        IA = new int[256];
        Arrays.fill(IA, -1);
        int n3 = CA.length;
        for (n2 = 0; n2 < n3; ++n2) {
            IOUtils.IA[IOUtils.CA[n2]] = n2;
        }
        IOUtils.IA[61] = 0;
    }
}

