/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.MathContext;

public final class JSONReaderScanner
extends JSONLexerBase {
    private static final ThreadLocal<char[]> r = new ThreadLocal();
    private Reader s;
    private char[] t;
    private int u;

    public JSONReaderScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(String string, int n2) {
        this(new StringReader(string), n2);
    }

    public JSONReaderScanner(char[] cArray, int n2) {
        this(cArray, n2, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader) {
        this(reader, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader, int n2) {
        super(n2);
        this.s = reader;
        this.t = r.get();
        if (this.t != null) {
            r.set(null);
        }
        if (this.t == null) {
            this.t = new char[16384];
        }
        try {
            this.u = reader.read(this.t);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        this.e = -1;
        this.next();
        if (this.d == '\ufeff') {
            this.next();
        }
    }

    public JSONReaderScanner(char[] cArray, int n2, int n3) {
        this(new CharArrayReader(cArray, 0, n2), n3);
    }

    @Override
    public final char charAt(int n2) {
        if (n2 >= this.u) {
            if (this.u == -1) {
                if (n2 < this.h) {
                    return this.t[n2];
                }
                return '\u001a';
            }
            if (this.e == 0) {
                char[] cArray = new char[this.t.length * 3 / 2];
                System.arraycopy(this.t, this.e, cArray, 0, this.u);
                int n3 = cArray.length - this.u;
                try {
                    n3 = this.s.read(cArray, this.u, n3);
                    this.u += n3;
                    this.t = cArray;
                }
                catch (IOException iOException) {
                    throw new JSONException(iOException.getMessage(), iOException);
                }
            }
            int n4 = this.u - this.e;
            if (n4 > 0) {
                System.arraycopy(this.t, this.e, this.t, 0, n4);
            }
            try {
                this.u = this.s.read(this.t, n4, this.t.length - n4);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException.getMessage(), iOException);
            }
            if (this.u == 0) {
                throw new JSONException("illegal state, textLength is zero");
            }
            if (this.u == -1) {
                return '\u001a';
            }
            this.u += n4;
            n2 -= this.e;
            this.i -= this.e;
            this.e = 0;
        }
        return this.t[n2];
    }

    @Override
    public final int indexOf(char c2, int n2) {
        n2 -= this.e;
        while (true) {
            int n3 = this.e + n2;
            if (c2 == (n3 = (int)this.charAt(n3))) {
                return n2 + this.e;
            }
            if (n3 == 26) {
                return -1;
            }
            ++n2;
        }
    }

    @Override
    public final String addSymbol(int n2, int n3, int n4, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.t, n2, n3, n4);
    }

    @Override
    public final char next() {
        int n2 = ++this.e;
        if (this.e >= this.u) {
            int n3;
            if (this.u == -1) {
                return '\u001a';
            }
            if (this.h > 0) {
                n3 = this.u - this.h;
                if (this.d == '\"' && n3 > 0) {
                    --n3;
                }
                System.arraycopy(this.t, n3, this.t, 0, this.h);
            }
            this.i = -1;
            n2 = this.e = this.h;
            try {
                n3 = this.e;
                int n4 = this.t.length - n3;
                if (n4 == 0) {
                    char[] cArray = new char[this.t.length * 2];
                    System.arraycopy(this.t, 0, cArray, 0, this.t.length);
                    this.t = cArray;
                    n4 = this.t.length - n3;
                }
                this.u = this.s.read(this.t, this.e, n4);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException.getMessage(), iOException);
            }
            if (this.u == 0) {
                throw new JSONException("illegal stat, textLength is zero");
            }
            if (this.u == -1) {
                this.d = '\u001a';
                return '\u001a';
            }
            this.u += this.e;
        }
        this.d = this.t[n2];
        return this.d;
    }

    @Override
    protected final void a(int n2, int n3, char[] cArray) {
        System.arraycopy(this.t, n2, cArray, 0, n3);
    }

    @Override
    public final boolean charArrayCompare(char[] cArray) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            JSONReaderScanner jSONReaderScanner = this;
            if (jSONReaderScanner.charAt(jSONReaderScanner.e + i2) == cArray[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final byte[] bytesValue() {
        if (this.a == 26) {
            throw new JSONException("TODO");
        }
        return IOUtils.decodeBase64(this.t, this.i + 1, this.h);
    }

    @Override
    protected final void a(int n2, char[] cArray, int n3) {
        System.arraycopy(this.t, n2, cArray, 0, n3);
    }

    @Override
    public final String stringVal() {
        if (!this.j) {
            int n2 = this.i + 1;
            if (n2 < 0) {
                throw new IllegalStateException();
            }
            if (n2 > this.t.length - this.h) {
                throw new IllegalStateException();
            }
            return new String(this.t, n2, this.h);
        }
        return new String(this.g, 0, this.h);
    }

    @Override
    public final String subString(int n2, int n3) {
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        return new String(this.t, n2, n3);
    }

    @Override
    public final char[] sub_chars(int n2, int n3) {
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 == 0) {
            return this.t;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.t, n2, cArray, 0, n3);
        return cArray;
    }

    @Override
    public final String numberString() {
        int n2 = this.i;
        if (n2 == -1) {
            n2 = 0;
        }
        char c2 = this.charAt(n2 + this.h - 1);
        int n3 = this.h;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n3;
        }
        return new String(this.t, n2, n3);
    }

    @Override
    public final BigDecimal decimalValue() {
        int n2 = this.i;
        if (n2 == -1) {
            n2 = 0;
        }
        char c2 = this.charAt(n2 + this.h - 1);
        int n3 = this.h;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n3;
        }
        if (n3 > 65535) {
            throw new JSONException("decimal overflow");
        }
        return new BigDecimal(this.t, n2, n3, MathContext.UNLIMITED);
    }

    @Override
    public final void close() {
        super.close();
        if (this.t.length <= 65536) {
            r.set(this.t);
        }
        this.t = null;
        IOUtils.close(this.s);
    }

    @Override
    public final boolean isEOF() {
        return this.u == -1 || this.e == this.t.length || this.d == '\u001a' && this.e + 1 >= this.t.length;
    }

    @Override
    public final boolean isBlankInput() {
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.t[n2]) == '\u001a') break;
            if (!JSONReaderScanner.isWhitespace(c2)) {
                return false;
            }
            ++n2;
        }
        this.a = 20;
        return true;
    }
}

