/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.crosspro.network.base.CPError;

public class CPErrorUtil {
    public static TPError getTradPlusErrorCode(CPError errorCode) {
        TPError tradPlusErrorCode = new TPError();
        switch (errorCode.getCode()) {
            case "301": {
                tradPlusErrorCode.setTpErrorCode("Third-party network failed to provide an ad.");
                break;
            }
            case "201": {
                tradPlusErrorCode.setTpErrorCode("Third-party network failed to respond in a timely manner.");
                break;
            }
            default: {
                tradPlusErrorCode.setTpErrorCode("Unspecified error.");
            }
        }
        tradPlusErrorCode.setErrorCode(errorCode.getCode() + "");
        tradPlusErrorCode.setErrorMessage(errorCode.getDesc());
        return tradPlusErrorCode;
    }

    public static TPError getErrorCode(VolleyError error) {
        TPError tradPlusErrorCode = new TPError("Can not init config data.");
        if (error == null) {
            tradPlusErrorCode.setErrorCode("12");
            tradPlusErrorCode.setErrorMessage("Can not init config data.");
        } else if (error instanceof TimeoutError) {
            tradPlusErrorCode.setErrorCode("3");
            tradPlusErrorCode.setErrorMessage("Third-party network failed to respond in a timely manner.");
        } else if (error instanceof NetworkError) {
            tradPlusErrorCode.setErrorCode("7");
            tradPlusErrorCode.setErrorMessage("No internet connection detected.");
        } else {
            tradPlusErrorCode.setErrorCode("2");
            tradPlusErrorCode.setErrorMessage("Unspecified error.");
        }
        return tradPlusErrorCode;
    }
}

