/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.applovin.carouselui.adapter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinErrorUtil;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInitManager;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInterstitialCallbackRouter;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AppLovinInterstitialVideo
extends TPRewardAdapter
implements AppLovinAdLoadListener,
AppLovinAdRewardListener,
AppLovinAdClickListener,
AppLovinAdVideoPlaybackListener,
AppLovinAdDisplayListener {
    public static final String TAG = "AppLovinRewardVideo";
    private AppLovinSdk mAppLovinSdk;
    private AppLovinAd loadedAd;
    private AppLovinIncentivizedInterstitial mAppLovinIncentivizedInterstitial;
    private AppLovinInterstitialCallbackRouter mAppLovinICBR;
    private String payload;
    private String appKey;
    private String zoneId;
    private String sdkKey;
    private String userId;
    private Context mContext;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.payload = (String)userParams.get("Bidding-Payload");
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.appKey = tpParams.get("appId");
        this.zoneId = tpParams.get("placementId");
        this.sdkKey = tpParams.get("Sdk_Key");
        if (userParams != null && userParams.size() > 0) {
            this.userId = (String)userParams.get("user_id");
            if (TextUtils.isEmpty((CharSequence)this.userId)) {
                this.userId = "";
            }
        }
        this.mAppLovinICBR = AppLovinInterstitialCallbackRouter.getInstance();
        this.mContext = context;
        this.mAppLovinSdk = AppLovinSdk.getInstance((Context)context);
        this.mAppLovinSdk.setMediationProvider("other");
        if (!TextUtils.isEmpty((CharSequence)this.userId)) {
            Log.i((String)TAG, (String)("RewardData: userId : " + this.userId));
            this.mAppLovinSdk.setUserIdentifier(this.userId);
        }
        this.mAppLovinSdk.getSettings().setVerboseLogging(TestDeviceUtil.getInstance().isNeedTestDevice());
        if (this.mLoadAdapterListener != null) {
            this.mAppLovinICBR.addListener(this.zoneId, this.mLoadAdapterListener);
        }
        if (!this.mAppLovinSdk.isInitialized()) {
            AppLovinInitManager.getInstance().initSDK(context, this.mAppLovinSdk, userParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    AppLovinInterstitialVideo.this.loadWithSdkInitialized();
                }

                public void onFailed(String code, String msg) {
                }
            });
        } else {
            this.loadWithSdkInitialized();
        }
    }

    protected void loadWithSdkInitialized() {
        if (TextUtils.isEmpty((CharSequence)this.payload)) {
            LogUtil.ownShow((String)"normal load");
            this.mAppLovinIncentivizedInterstitial = AppLovinIncentivizedInterstitial.create((String)this.zoneId, (AppLovinSdk)this.mAppLovinSdk);
            this.mAppLovinIncentivizedInterstitial.preload((AppLovinAdLoadListener)this);
        } else {
            LogUtil.ownShow((String)"bidding load");
            AppLovinSdk.getInstance((Context)this.mContext).getAdService().loadNextAdForAdToken(this.payload, (AppLovinAdLoadListener)this);
        }
    }

    public void showAd() {
        Activity activity;
        if (this.mAppLovinICBR != null && this.zoneId != null && this.mShowListener != null) {
            this.mAppLovinICBR.addShowListener(this.zoneId, this.mShowListener);
        }
        if ((activity = GlobalTradPlus.getInstance().getActivity()) == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
        } else if (this.mAppLovinIncentivizedInterstitial.isAdReadyToDisplay()) {
            if (this.zoneId != null && this.zoneId.length() > 0) {
                this.mAppLovinIncentivizedInterstitial.show((Context)activity, this.zoneId, (AppLovinAdRewardListener)this, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
            } else {
                this.mAppLovinIncentivizedInterstitial.show((Context)activity, (AppLovinAdRewardListener)this, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
            }
        } else {
            if (this.zoneId != null && this.zoneId.length() > 0 && this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
                this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            }
            Log.i((String)TAG, (String)"Tried to show a AppLovin rewarded ad before it finished loading. Please try again.");
        }
    }

    public boolean isReady() {
        if (this.mAppLovinIncentivizedInterstitial == null) {
            return false;
        }
        return this.mAppLovinIncentivizedInterstitial.isAdReadyToDisplay();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("9");
    }

    public String getNetworkVersion() {
        return AppLovinSdk.VERSION;
    }

    public void clean() {
        super.clean();
        if (this.zoneId != null) {
            this.mAppLovinICBR.removeListeners(this.zoneId);
        }
    }

    public void adReceived(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("adReceived:ZoneId:" + appLovinAd.getZoneId()));
        if (this.mAppLovinICBR.getListener(this.zoneId) != null) {
            this.mAppLovinICBR.getListener(this.zoneId).loadAdapterLoaded(null);
        }
    }

    public void failedToReceiveAd(int errorCode) {
        Log.i((String)TAG, (String)("AppLovin rewarded ad failed to load with error code :" + errorCode));
        if (this.mAppLovinICBR.getListener(this.zoneId) != null) {
            this.mAppLovinICBR.getListener(this.zoneId).loadAdapterLoadFailed(AppLovinErrorUtil.getTradPlusErrorCode(errorCode));
        }
    }

    public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"userDeclinedToViewAd: ");
    }

    public void userOverQuota(AppLovinAd appLovinAd, Map map) {
        Log.i((String)TAG, (String)"userOverQuota: ");
    }

    public void userRewardRejected(AppLovinAd appLovinAd, Map map) {
        Log.i((String)TAG, (String)"userRewardRejected: ");
    }

    public void userRewardVerified(AppLovinAd appLovinAd, Map map) {
        try {
            String currencyName = (String)map.get("currency");
            String amountGivenString = (String)map.get("amount");
            Log.i((String)"TradPlus", (String)("AppLovin rewarded ad " + amountGivenString + " " + currencyName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validationRequestFailed(AppLovinAd appLovinAd, int errorCode) {
        Log.i((String)TAG, (String)"validationRequestFailed: ");
    }

    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"videoPlaybackBegan: ");
    }

    public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
        Log.i((String)TAG, (String)("videoPlaybackEnded: ZoneId:" + appLovinAd.getZoneId()));
        if (b && this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onReward();
        }
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("adDisplayed: ZoneId:" + appLovinAd.getZoneId()));
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoStart();
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("adHidden:  ZoneId:" + appLovinAd.getZoneId()));
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoEnd();
        }
    }

    public void adClicked(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("adClicked:  ZoneId:" + appLovinAd.getZoneId()));
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoClicked();
        }
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }
}

