/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.applovin.carouselui.adapter;

import android.content.Context;
import android.util.Log;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AppLovinInitManager
extends TPInitMediation {
    private static final String TAG = "AppLovin";
    private static AppLovinInitManager sInstance;

    public static synchronized AppLovinInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new AppLovinInitManager();
        }
        return sInstance;
    }

    public void initSDK(Context context, AppLovinSdk appLovinSdk, Map<String, Object> userParams, TPInitMediation.InitCallback initCallback) {
        final String customAs = RequestUtils.getInstance().getCustomAs("9");
        if (this.isInited(customAs)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(customAs, initCallback)) {
            return;
        }
        this.suportGDPR(context, userParams);
        appLovinSdk.setMediationProvider("other");
        appLovinSdk.getSettings().setVerboseLogging(TestDeviceUtil.getInstance().isNeedTestDevice());
        appLovinSdk.initializeSdk(new AppLovinSdk.SdkInitializationListener(){

            public void onSdkInitialized(AppLovinSdkConfiguration config) {
                Log.i((String)AppLovinInitManager.TAG, (String)("onSdkInitialized: " + AppLovinSdk.VERSION));
                Log.d((String)"InitNetworkSDK", (String)"initSDK: ");
                AppLovinInitManager.this.sendResult(customAs, true);
            }
        });
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
    }

    public void suportGDPR(Context context, Map<String, Object> localExtras) {
        if (localExtras != null && localExtras.size() > 0) {
            if (localExtras.containsKey("gdpr_consent") && localExtras.containsKey("isue")) {
                boolean need_set_gdpr = false;
                int consent = (Integer)localExtras.get("gdpr_consent");
                if (consent == 0) {
                    need_set_gdpr = true;
                }
                boolean isEu = (Boolean)localExtras.get("isue");
                Log.i((String)TAG, (String)("suportGDPR: " + need_set_gdpr + ":isUe:" + isEu));
                AppLovinPrivacySettings.setHasUserConsent((boolean)need_set_gdpr, (Context)context);
            }
            Log.i((String)TAG, (String)("suportGDPR :COPPA:" + localExtras.get("COPPA") + ":ccpa:" + localExtras.get("CCPA")));
            if (localExtras.containsKey("COPPA")) {
                boolean coppa = (Boolean)localExtras.get("COPPA");
                AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)coppa, (Context)context);
            }
            if (localExtras.containsKey("CCPA")) {
                boolean ccpa = (Boolean)localExtras.get("CCPA");
                AppLovinPrivacySettings.setDoNotSell((!ccpa ? 1 : 0) != 0, (Context)context);
            }
        }
    }
}

