/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.applovin.carouselui.adapter;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.applovin.adview.AppLovinAdView;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinSdk;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinErrorUtil;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInitManager;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.Views;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AppLovinBanner
extends TPBannerAdapter
implements AppLovinAdLoadListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener {
    public static final String TAG = "AppLovinBanner";
    private AppLovinSdk mAppLovinSdk;
    private AppLovinAdView mAppLovinBanner;
    private String mAdSize;
    private String appKey;
    private String zoneId;
    private String sdkKey;
    private TPBannerAdImpl mTpBannerAd;
    Context mContext;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.mContext = context;
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.appKey = tpParams.get("appId");
        this.zoneId = tpParams.get("placementId");
        this.sdkKey = tpParams.get("Sdk_Key");
        this.mAdSize = tpParams.get("ad_size" + this.zoneId) != null ? tpParams.get("ad_size" + this.zoneId) : "1";
        Log.i((String)TAG, (String)("BannerSize: " + this.mAdSize + ". '1' means ad size will be 320 * 50 , '2' means ad size will be 728* 90"));
        this.mAppLovinSdk = AppLovinSdk.getInstance((Context)context);
        if (!this.mAppLovinSdk.isInitialized()) {
            AppLovinInitManager.getInstance().initSDK(context, this.mAppLovinSdk, userParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    AppLovinBanner.this.looadAppLovinAds();
                }

                public void onFailed(String code, String msg) {
                }
            });
        } else {
            this.looadAppLovinAds();
        }
    }

    private void looadAppLovinAds() {
        this.mAppLovinBanner = new AppLovinAdView(this.calculateAdSize(this.mAdSize), this.zoneId, this.mContext);
        this.mAppLovinBanner.setId(Views.generateViewId());
        this.mAppLovinBanner.setAdLoadListener((AppLovinAdLoadListener)this);
        this.mAppLovinBanner.setAdDisplayListener((AppLovinAdDisplayListener)this);
        this.mAppLovinBanner.setAdClickListener((AppLovinAdClickListener)this);
        this.mAppLovinBanner.loadNextAd();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public void clean() {
        if (this.mAppLovinBanner != null) {
            Views.removeFromParent((View)this.mAppLovinBanner);
            this.mAppLovinBanner.destroy();
            this.mAppLovinBanner = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("9");
    }

    public String getNetworkVersion() {
        return AppLovinSdk.VERSION;
    }

    public void adReceived(AppLovinAd appLovinAd) {
        if (this.mAppLovinBanner == null) {
            return;
        }
        Log.i((String)TAG, (String)"AppLovin banner ad loaded successfully. Showing ad...");
        this.mTpBannerAd = new TPBannerAdImpl(null, (View)this.mAppLovinBanner);
        RelativeLayout relativeLayout = new RelativeLayout(this.mContext);
        if (this.mAdSize.equals("3")) {
            this.mAppLovinBanner.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(DeviceUtils.dip2px((Context)this.mContext, (float)728.0f), DeviceUtils.dip2px((Context)this.mContext, (float)90.0f)));
        } else {
            this.mAppLovinBanner.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(DeviceUtils.dip2px((Context)this.mContext, (float)320.0f), DeviceUtils.dip2px((Context)this.mContext, (float)50.0f)));
        }
        relativeLayout.addView((View)this.mAppLovinBanner);
        relativeLayout.setGravity(17);
        this.mTpBannerAd = new TPBannerAdImpl(null, (View)relativeLayout);
        if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mTpBannerAd);
        }
    }

    public void failedToReceiveAd(int errorCode) {
        Log.i((String)TAG, (String)("AppLovin banner ad failed to load with error code " + errorCode));
        if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(AppLovinErrorUtil.getTradPlusErrorCode(errorCode));
        }
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"AppLovin banner ad loaded Displayed");
        if (this.mTpBannerAd != null) {
            this.mTpBannerAd.adShown();
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"AppLovin banner ad loaded Hidden");
    }

    public void adClicked(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"AppLovin banner ad loaded Clicked");
        if (this.mTpBannerAd != null) {
            this.mTpBannerAd.adClicked();
        }
    }

    private AppLovinAdSize calculateAdSize(String adSize) {
        Log.i((String)TAG, (String)("calculateAdSize: " + adSize));
        if (adSize.equals("1")) {
            return AppLovinAdSize.BANNER;
        }
        if (adSize.equals("3")) {
            return AppLovinAdSize.LEADER;
        }
        return AppLovinAdSize.BANNER;
    }
}

