/*
 * Decompiled with CFR 0.152.
 */
package org.libpag;

import android.content.res.AssetManager;
import android.util.Xml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.extra.tools.LibraryLoadUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PAGFont {
    public String fontFamily = "";
    public String fontStyle = "";
    private static final String DefaultLanguage = "zh-Hans";
    private static final String SystemFontConfigPath_Lollipop = "/system/etc/fonts.xml";
    private static final String SystemFontConfigPath_JellyBean = "/system/etc/fallback_fonts.xml";
    private static final String SystemFontPath = "/system/fonts/";
    private static final String[] FallbackFontFileNames = new String[]{"/system/fonts/NotoSansCJK-Regular.ttc", "/system/fonts/NotoSansSC-Regular.otf", "/system/fonts/DroidSansFallback.ttf"};
    private static final Pattern FILENAME_WHITESPACE_PATTERN = Pattern.compile("^[ \\n\\r\\t]+|[ \\n\\r\\t]+$");
    private static boolean systemFontLoaded = false;

    public static PAGFont RegisterFont(String fontPath) {
        return PAGFont.RegisterFont(fontPath, 0);
    }

    public static PAGFont RegisterFont(AssetManager manager, String fileName) {
        return PAGFont.RegisterFont(manager, fileName, 0);
    }

    public static PAGFont RegisterFont(AssetManager manager, String fileName, int ttcIndex) {
        return PAGFont.RegisterFont(manager, fileName, ttcIndex, "", "");
    }

    public static native PAGFont RegisterFont(AssetManager var0, String var1, int var2, String var3, String var4);

    public static PAGFont RegisterFont(String fontPath, int ttcIndex) {
        return PAGFont.RegisterFont(fontPath, ttcIndex, "", "");
    }

    public static native PAGFont RegisterFont(String var0, int var1, String var2, String var3);

    public static void UnregisterFont(PAGFont font) {
        PAGFont.UnregisterFont(font.fontFamily, font.fontStyle);
    }

    private static native void UnregisterFont(String var0, String var1);

    private static PAGFont RegisterFontBytes(byte[] bytes, int length, int ttcIndex) {
        return PAGFont.RegisterFontBytes(bytes, length, ttcIndex, "", "");
    }

    private static native PAGFont RegisterFontBytes(byte[] var0, int var1, int var2, String var3, String var4);

    private static native void SetFallbackFontPaths(String[] var0, int[] var1);

    public PAGFont() {
    }

    public PAGFont(String fontFamily, String fontStyle) {
        this.fontFamily = fontFamily;
        this.fontStyle = fontStyle;
    }

    private static FontConfig[] parseLollipop() throws XmlPullParserException, IOException {
        FileInputStream fontsIn;
        FontConfig[] fontList = new FontConfig[]{};
        try {
            fontsIn = new FileInputStream(SystemFontConfigPath_Lollipop);
        }
        catch (IOException e) {
            return fontList;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)fontsIn, null);
            parser.nextTag();
            fontList = PAGFont.readFamilies(parser);
        }
        finally {
            fontsIn.close();
        }
        return fontList;
    }

    private static FontConfig[] readFamilies(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<FontConfig> fallbackList = new ArrayList<FontConfig>();
        parser.require(2, null, "familyset");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                PAGFont.readFamily(parser, fallbackList);
                continue;
            }
            PAGFont.skip(parser);
        }
        FontConfig[] list = new FontConfig[fallbackList.size()];
        fallbackList.toArray(list);
        return list;
    }

    private static void readFamily(XmlPullParser parser, ArrayList<FontConfig> fontList) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        String lang = parser.getAttributeValue(null, "lang");
        ArrayList<FontConfig> fonts = new ArrayList<FontConfig>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                fonts.add(PAGFont.readFont(parser));
                continue;
            }
            PAGFont.skip(parser);
        }
        if (fonts.isEmpty()) {
            return;
        }
        FontConfig regularFont = null;
        for (FontConfig font : fonts) {
            if (font.weight != 400) continue;
            regularFont = font;
            break;
        }
        if (regularFont == null) {
            regularFont = (FontConfig)fonts.get(0);
        }
        if (!regularFont.fileName.isEmpty()) {
            regularFont.language = lang == null ? "" : lang;
            fontList.add(regularFont);
        }
    }

    private static FontConfig readFont(XmlPullParser parser) throws XmlPullParserException, IOException {
        FontConfig font = new FontConfig();
        String indexStr = parser.getAttributeValue(null, "index");
        font.ttcIndex = indexStr == null ? 0 : Integer.parseInt(indexStr);
        String weightStr = parser.getAttributeValue(null, "weight");
        font.weight = weightStr == null ? 400 : Integer.parseInt(weightStr);
        StringBuilder filename = new StringBuilder();
        while (parser.next() != 3) {
            if (parser.getEventType() == 4) {
                filename.append(parser.getText());
            }
            if (parser.getEventType() != 2) continue;
            PAGFont.skip(parser);
        }
        font.fileName = SystemFontPath + FILENAME_WHITESPACE_PATTERN.matcher(filename).replaceAll("");
        return font;
    }

    private static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }

    private static FontConfig[] parseJellyBean() throws XmlPullParserException, IOException {
        FileInputStream fontsIn;
        FontConfig[] fontList = new FontConfig[]{};
        try {
            fontsIn = new FileInputStream(SystemFontConfigPath_JellyBean);
        }
        catch (IOException e) {
            return fontList;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)fontsIn, null);
            parser.nextTag();
            fontList = PAGFont.readFamiliesJellyBean(parser);
        }
        finally {
            fontsIn.close();
        }
        return fontList;
    }

    private static FontConfig[] readFamiliesJellyBean(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<FontConfig> fallbackList = new ArrayList<FontConfig>();
        parser.require(2, null, "familyset");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("family")) {
                while (parser.next() != 3) {
                    if (parser.getEventType() != 2) continue;
                    tag = parser.getName();
                    if (tag.equals("fileset")) {
                        PAGFont.readFileset(parser, fallbackList);
                        continue;
                    }
                    PAGFont.skip(parser);
                }
                continue;
            }
            PAGFont.skip(parser);
        }
        FontConfig[] list = new FontConfig[fallbackList.size()];
        fallbackList.toArray(list);
        return list;
    }

    private static void readFileset(XmlPullParser parser, ArrayList<FontConfig> fontList) throws XmlPullParserException, IOException {
        ArrayList<FontConfig> fonts = new ArrayList<FontConfig>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("file")) {
                fonts.add(PAGFont.readFont(parser));
                continue;
            }
            PAGFont.skip(parser);
        }
        if (fonts.isEmpty()) {
            return;
        }
        FontConfig regularFont = null;
        for (FontConfig font : fonts) {
            if (font.weight != 400) continue;
            regularFont = font;
            break;
        }
        if (regularFont == null) {
            regularFont = (FontConfig)fonts.get(0);
        }
        if (!regularFont.fileName.isEmpty()) {
            fontList.add(regularFont);
        }
    }

    private static FontConfig getFontByLanguage(FontConfig[] fontList, String language) {
        language = language.toLowerCase();
        for (FontConfig fontConfig : fontList) {
            if (!fontConfig.language.toLowerCase().equals(language)) continue;
            return fontConfig;
        }
        return null;
    }

    private static void addFont(FontConfig fontConfig, ArrayList<String> fontPaths, ArrayList<Integer> ttcList) {
        if (fontPaths.contains(fontConfig.fileName)) {
            return;
        }
        File file = new File(fontConfig.fileName);
        if (!file.exists()) {
            return;
        }
        fontPaths.add(fontConfig.fileName);
        ttcList.add(fontConfig.ttcIndex);
    }

    private static void RegisterFallbackFonts() {
        if (systemFontLoaded) {
            return;
        }
        systemFontLoaded = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                FontConfig[] fontList = new FontConfig[]{};
                File lollipopFile = new File(PAGFont.SystemFontConfigPath_Lollipop);
                if (lollipopFile.exists()) {
                    try {
                        fontList = PAGFont.parseLollipop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        fontList = PAGFont.parseJellyBean();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ArrayList fontPaths = new ArrayList();
                ArrayList ttcList = new ArrayList();
                FontConfig font = PAGFont.getFontByLanguage(fontList, PAGFont.DefaultLanguage);
                if (font != null) {
                    PAGFont.addFont(font, fontPaths, ttcList);
                }
                for (String fileName : FallbackFontFileNames) {
                    font = new FontConfig();
                    font.fileName = fileName;
                    PAGFont.addFont(font, fontPaths, ttcList);
                }
                for (FontConfig fontConfig : fontList) {
                    PAGFont.addFont(fontConfig, fontPaths, ttcList);
                }
                if (!fontPaths.isEmpty()) {
                    String[] fontPathList = new String[fontPaths.size()];
                    fontPaths.toArray(fontPathList);
                    int[] ttcIndices = new int[ttcList.size()];
                    int index = 0;
                    for (Integer ttcIndex : ttcList) {
                        ttcIndices[index++] = ttcIndex;
                    }
                    PAGFont.SetFallbackFontPaths(fontPathList, ttcIndices);
                }
            }
        }).start();
    }

    static {
        LibraryLoadUtils.loadLibrary("pag");
    }

    private static class FontConfig {
        String language = "";
        String fileName = "";
        int ttcIndex = 0;
        int weight = 400;

        private FontConfig() {
        }
    }
}

