/*
 * Decompiled with CFR 0.152.
 */
package org.extra.tools;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HttpsURLConnection;
import org.extra.tools.ContextProvider;
import org.json.JSONObject;
import org.libpag.PAG;

public class Reporter {
    private static final String PAG_VERSION_KEY = "last_pag_version";
    private static final AtomicReference<ReportState> state = new AtomicReference<ReportState>(ReportState.Unreported);

    public static void report() {
        if (state.get() != ReportState.Unreported) {
            return;
        }
        state.set(ReportState.Reporting);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Reporter.reportInternal();
            }
        });
    }

    private static void reportInternal() {
        String appName;
        Context context = ContextProvider.getApplicationContext();
        if (context == null) {
            state.set(ReportState.Unreported);
            return;
        }
        String sdkVersion = PAG.SDKVersion();
        if (TextUtils.isEmpty((CharSequence)sdkVersion)) {
            state.set(ReportState.Unreported);
            return;
        }
        SharedPreferences prefs = context.getSharedPreferences("pag_reporter", 0);
        String lastVersion = prefs.getString(PAG_VERSION_KEY, "");
        if (sdkVersion.equals(lastVersion)) {
            state.set(ReportState.Reported);
            return;
        }
        String appID = context.getPackageName();
        if (TextUtils.isEmpty((CharSequence)appID)) {
            state.set(ReportState.Unreported);
            return;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(appID, 0);
            appName = packageInfo.applicationInfo.loadLabel(packageManager).toString();
        }
        catch (Throwable ignored) {
            appName = "";
        }
        if (0 != packageManager.checkPermission("android.permission.INTERNET", appID)) {
            state.set(ReportState.Unreported);
            return;
        }
        if (Reporter.report(sdkVersion, appName, appID, lastVersion)) {
            prefs.edit().putString(PAG_VERSION_KEY, sdkVersion).apply();
            state.set(ReportState.Reported);
        } else {
            state.set(ReportState.Unreported);
        }
    }

    private static boolean report(String sdkVersion, String appName, String appID, String lastVersion) {
        boolean success = false;
        try {
            URL url = new URL("https://otheve.beacon.qq.com/analytics/v2_upload");
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(5000);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(Reporter.requestJSON(sdkVersion, appName, appID, lastVersion));
            bufferedWriter.flush();
            bufferedWriter.close();
            outputStreamWriter.close();
            conn.connect();
            if (conn.getResponseCode() == 200) {
                String line;
                StringBuilder response = new StringBuilder();
                InputStreamReader inputStreamReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                bufferedReader.close();
                inputStreamReader.close();
                JSONObject jsonObject = new JSONObject(response.toString());
                if (jsonObject.optInt("result") == 200) {
                    success = true;
                }
            }
            conn.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return success;
    }

    private static String requestJSON(String sdkVersion, String appName, String appID, String lastVersion) {
        return "{\"appVersion\":\"\",\"sdkId\":\"\",\"sdkVersion\":\"" + sdkVersion + "\",\"mainAppKey\":\"0DOU0K0WD05SLYU3\",\"platformId\":\"\",\"common\":{\"A2\":\"pag_sdk_report\"},\"events\":[{\"eventCode\":\"pag_sdk_report\",\"eventTime\":\"" + System.currentTimeMillis() + "\",\"mapValue\":{\"appName\":\"" + appName + "\",\"appID\":\"" + appID + "\",\"appPlatform\":\"Android\",\"previousSDKVersion\":\"" + lastVersion + "\"}}]}";
    }

    private static enum ReportState {
        Unreported,
        Reporting,
        Reported;

    }
}

