/*
 * Decompiled with CFR 0.152.
 */
package org.extra.relinker;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.extra.relinker.MissingLibraryException;
import org.extra.relinker.ReLinker;
import org.extra.relinker.ReLinkerInstance;

public class ApkLibraryInstaller
implements ReLinker.LibraryInstaller {
    private static final int MAX_TRIES = 5;
    private static final int COPY_BUFFER_SIZE = 4096;

    private String[] sourceDirectories(Context context) {
        ApplicationInfo appInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 21 && appInfo.splitSourceDirs != null && appInfo.splitSourceDirs.length != 0) {
            String[] apks = new String[appInfo.splitSourceDirs.length + 1];
            apks[0] = appInfo.sourceDir;
            System.arraycopy(appInfo.splitSourceDirs, 0, apks, 1, appInfo.splitSourceDirs.length);
            return apks;
        }
        return new String[]{appInfo.sourceDir};
    }

    private ZipFileInZipEntry findAPKWithLibrary(Context context, String[] abis, String mappedLibraryName, ReLinkerInstance instance) {
        ZipFile zipFile = null;
        for (String sourceDir : this.sourceDirectories(context)) {
            int tries = 0;
            while (tries++ < 5) {
                try {
                    zipFile = new ZipFile(new File(sourceDir), 1);
                    break;
                }
                catch (IOException iOException) {
                }
            }
            if (zipFile == null) continue;
            tries = 0;
            while (tries++ < 5) {
                String jniNameInApk = null;
                ZipEntry libraryEntry = null;
                for (String abi : abis) {
                    jniNameInApk = "lib" + File.separatorChar + abi + File.separatorChar + mappedLibraryName;
                    instance.log("Looking for %s in APK %s...", jniNameInApk, sourceDir);
                    libraryEntry = zipFile.getEntry(jniNameInApk);
                    if (libraryEntry == null) continue;
                    return new ZipFileInZipEntry(zipFile, libraryEntry);
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void installLibrary(Context context, String[] abis, String mappedLibraryName, File destination, ReLinkerInstance instance) {
        ZipFileInZipEntry found = null;
        try {
            found = this.findAPKWithLibrary(context, abis, mappedLibraryName, instance);
            if (found == null) {
                throw new MissingLibraryException(mappedLibraryName);
            }
            int tries = 0;
            while (tries++ < 5) {
                instance.log("Found %s! Extracting...", mappedLibraryName);
                try {
                    if (!destination.exists() && !destination.createNewFile()) {
                    }
                }
                catch (IOException ignored) {}
                continue;
                InputStream inputStream = null;
                FileOutputStream fileOut = null;
                try {
                    inputStream = found.zipFile.getInputStream(found.zipEntry);
                    fileOut = new FileOutputStream(destination);
                    long written = this.copy(inputStream, fileOut);
                    fileOut.getFD().sync();
                    if (written != destination.length()) {
                        this.closeSilently(inputStream);
                        this.closeSilently(fileOut);
                        continue;
                    }
                    this.closeSilently(inputStream);
                    this.closeSilently(fileOut);
                }
                catch (FileNotFoundException e) {
                    this.closeSilently(inputStream);
                    this.closeSilently(fileOut);
                    continue;
                }
                catch (IOException e2) {
                    this.closeSilently(inputStream);
                    this.closeSilently(fileOut);
                    continue;
                    {
                        catch (Throwable throwable) {
                            this.closeSilently(inputStream);
                            this.closeSilently(fileOut);
                            throw throwable;
                        }
                    }
                }
                destination.setReadable(true, false);
                destination.setExecutable(true, false);
                destination.setWritable(true);
                return;
            }
            instance.log("FATAL! Couldn't extract the library from the APK!");
        }
        finally {
            try {
                if (found != null && found.zipFile != null) {
                    found.zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private long copy(InputStream in, OutputStream out) throws IOException {
        int read;
        long copied = 0L;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) != -1) {
            out.write(buf, 0, read);
            copied += (long)read;
        }
        out.flush();
        return copied;
    }

    private void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ZipFileInZipEntry {
        public ZipFile zipFile;
        public ZipEntry zipEntry;

        public ZipFileInZipEntry(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }
    }
}

