/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.video;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Bundle;
import android.os.Parcelable;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.utils.c;
import com.tencent.liteav.videoproducer.capture.VirtualDisplayManager;
import com.tencent.rtmp.video.ScreenCaptureService;
import java.util.ArrayList;
import java.util.HashMap;

public class TXScreenCapture {

    public static class TXScreenCaptureAssistantActivity
    extends Activity {
        private static final String TAG = "TXScreenCaptureAssistantActivity";
        private static final String FINISH_ACTIVITY_ACTION = "com.tencent.liteav.video.action.FINISH_SCREEN_CAPTURE_ACTIVITY";
        private static final int REQUEST_CODE = 100;
        private MediaProjectionManager mMediaProjectionManager;
        private final BroadcastReceiver mFinishReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                TXScreenCaptureAssistantActivity.this.finish();
            }
        };

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            LiteavLog.i(TAG, "onCreate ".concat(String.valueOf((Object)this)));
            this.requestWindowFeature(1);
            this.mMediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
            Intent intent = this.mMediaProjectionManager.createScreenCaptureIntent();
            try {
                this.startActivityForResult(intent, 100);
            }
            catch (Throwable throwable) {
                LiteavLog.e(TAG, "Start permission activity failed. ".concat(String.valueOf(throwable)));
                VirtualDisplayManager.a((Context)this).a(null);
                this.finish();
            }
            IntentFilter intentFilter = new IntentFilter(FINISH_ACTIVITY_ACTION);
            c.a().a(this.mFinishReceiver, intentFilter);
        }

        public void onActivityResult(int requestCode, int resultCode, Intent data) {
            LiteavLog.i(TAG, "onActivityResult " + (Object)((Object)this) + ", resultCode:" + resultCode + ", data:" + data);
            if (data == null) {
                VirtualDisplayManager.a((Context)this).a(null);
                this.finish();
                return;
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 26) {
                LiteavLog.i(TAG, "startForegroundService");
                Intent intent = new Intent((Context)this, ScreenCaptureService.class);
                intent.putExtra("code", resultCode);
                intent.putExtra("data", (Parcelable)data);
                this.startForegroundService(intent);
            } else {
                MediaProjection mediaProjection = null;
                try {
                    mediaProjection = this.mMediaProjectionManager.getMediaProjection(resultCode, data);
                }
                catch (Throwable throwable) {
                    LiteavLog.e(TAG, "onActivityResult mMediaProjectionManager.getMediaProjection fail.", throwable);
                }
                LiteavLog.i(TAG, "ProjectionManger get mediaProjection:".concat(String.valueOf(mediaProjection)));
                VirtualDisplayManager.a((Context)this).a(mediaProjection);
            }
            this.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onDestroy() {
            super.onDestroy();
            LiteavLog.i(TAG, "onDestroy ".concat(String.valueOf((Object)this)));
            BroadcastReceiver broadcastReceiver = this.mFinishReceiver;
            c c2 = c.a();
            HashMap<BroadcastReceiver, ArrayList<c.b>> hashMap = c2.b;
            synchronized (hashMap) {
                ArrayList<c.b> arrayList = c2.b.remove(broadcastReceiver);
                if (arrayList == null) {
                    return;
                }
                for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
                    c.b b2 = arrayList.get(i2);
                    arrayList.get(i2).d = true;
                    for (int i3 = 0; i3 < b2.a.countActions(); ++i3) {
                        String string = b2.a.getAction(i3);
                        ArrayList<c.b> arrayList2 = c2.c.get(string);
                        if (arrayList2 == null) continue;
                        for (int i4 = arrayList2.size() - 1; i4 >= 0; --i4) {
                            c.b b3 = arrayList2.get(i4);
                            if (b3.b != broadcastReceiver) continue;
                            b3.d = true;
                            arrayList2.remove(i4);
                        }
                        if (arrayList2.size() > 0) continue;
                        c2.c.remove(string);
                    }
                }
                return;
            }
        }
    }
}

