/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videoconsumer.renderer.RenderViewHelperInterface;

@JNINamespace(value="liteav::video")
class NativeRenderViewListener
implements RenderViewHelperInterface.RenderViewListener {
    private long mNativeHandler;

    public NativeRenderViewListener(long nativeHandler) {
        this.mNativeHandler = nativeHandler;
    }

    public synchronized void resetNativeHandle() {
        this.mNativeHandler = 0L;
    }

    @Override
    public synchronized void onSurfaceChanged(Surface surface, boolean isNeedRelease) {
        if (this.mNativeHandler != 0L) {
            NativeRenderViewListener.nativeOnSurfaceChanged(this.mNativeHandler, surface, isNeedRelease);
        }
    }

    @Override
    public synchronized void onRequestRedraw(Bitmap bitmap) {
        if (this.mNativeHandler != 0L) {
            NativeRenderViewListener.nativeOnRequestRedraw(this.mNativeHandler, bitmap);
        }
    }

    @Override
    public synchronized void onSurfaceDestroy() {
        if (this.mNativeHandler != 0L) {
            NativeRenderViewListener.nativeOnSurfaceDestroy(this.mNativeHandler);
        }
    }

    private static native void nativeOnSurfaceChanged(long var0, Surface var2, boolean var3);

    private static native void nativeOnRequestRedraw(long var0, Bitmap var2);

    private static native void nativeOnSurfaceDestroy(long var0);
}

