/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.egl;

import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.egl.a;
import com.tencent.liteav.videobase.egl.b;
import com.tencent.liteav.videobase.egl.c;
import com.tencent.liteav.videobase.egl.d;
import com.tencent.liteav.videobase.egl.e;
import java.util.concurrent.atomic.AtomicInteger;

@JNINamespace(value="liteav::video")
public class EGLCore {
    private static final String TAG = "EGLCore";
    private static final long DESTROY_EGL_CORE_DELAY_TIME_MS = 100L;
    private static final int MAX_EGL_CORE_COUNT = 50;
    private static final l sSequenceTaskRunner = new l();
    private static final AtomicInteger sEGLCoreCount = new AtomicInteger();
    private boolean mIsOffScreen = false;
    private e<?> mEglHelper;
    private Object mSharedContext;

    public static EGLCore create(Object sharedGLContext) {
        EGLCore eGLCore = new EGLCore();
        try {
            eGLCore.initialize(sharedGLContext, null, 128, 128);
            eGLCore.makeCurrent();
        }
        catch (d d2) {
            LiteavLog.e(TAG, "create EGLCore failed.", d2);
            eGLCore = null;
        }
        return eGLCore;
    }

    public static void destroy(EGLCore eglCore) {
        if (eglCore == null) {
            return;
        }
        eglCore.unmakeCurrent();
        Runnable runnable = c.a(eglCore);
        if (!eglCore.mIsOffScreen) {
            runnable.run();
            return;
        }
        sSequenceTaskRunner.a(runnable, 100L);
    }

    public void initialize(Object sharedContext, Surface surface, int width, int height) throws d {
        boolean bl = this.mIsOffScreen = surface == null;
        if (sharedContext == null) {
            this.mEglHelper = LiteavSystemInfo.getSystemOSVersionInt() >= 17 ? b.a(null, surface, width, height) : a.a(null, surface, width, height);
        } else if (sharedContext instanceof javax.microedition.khronos.egl.EGLContext) {
            this.mEglHelper = a.a((javax.microedition.khronos.egl.EGLContext)sharedContext, surface, width, height);
        } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 17 && sharedContext instanceof EGLContext) {
            this.mEglHelper = b.a((EGLContext)sharedContext, surface, width, height);
        } else {
            throw new d(0, "sharedContext isn't EGLContext");
        }
        this.mSharedContext = sharedContext;
        int n2 = sEGLCoreCount.incrementAndGet();
        LiteavLog.i(TAG, "EGLCore created in thread " + Thread.currentThread().getId() + ", sharedContext: " + sharedContext + ", Surface: " + surface + ", width: " + width + ", height: " + height + ", eglCoreCount: " + n2);
    }

    public Size getSurfaceSize() {
        if (this.mEglHelper == null) {
            return new Size(0, 0);
        }
        return this.mEglHelper.e();
    }

    public Object getSharedContext() {
        return this.mSharedContext;
    }

    public void makeCurrent() throws d {
        if (this.mEglHelper != null) {
            this.mEglHelper.b();
        }
    }

    public void unmakeCurrent() {
        if (this.mEglHelper != null) {
            this.mEglHelper.d();
        }
    }

    public void swapBuffers() throws d {
        if (this.mEglHelper != null) {
            this.mEglHelper.a();
        }
    }

    public Object getEglContext() {
        if (this.mEglHelper == null) {
            return null;
        }
        return this.mEglHelper.f();
    }

    private void uninitialize() throws d {
        if (this.mEglHelper != null) {
            this.mEglHelper.c();
            this.mEglHelper = null;
        }
        this.mSharedContext = null;
        sEGLCoreCount.decrementAndGet();
    }

    public void setPresentationTime(long nsecs) {
        if (this.mEglHelper != null && this.mEglHelper instanceof b) {
            b b2 = (b)this.mEglHelper;
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)b2.a, (EGLSurface)b2.b, (long)nsecs);
        }
    }

    static /* synthetic */ void lambda$destroy$0(EGLCore eglCore) {
        try {
            eglCore.uninitialize();
            LiteavLog.i(TAG, "EGLCore destroy success. ".concat(String.valueOf(eglCore)));
            return;
        }
        catch (d d2) {
            LiteavLog.e(TAG, "EGLCore destroy failed.", d2);
            return;
        }
    }
}

