package com.tencent.imsdk.relationship;

import com.tencent.imsdk.BaseConstants;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.officialaccount.OfficialAccountInfo;
import com.tencent.imsdk.officialaccount.OfficialAccountInfoResult;
import java.util.HashMap;
import java.util.List;

public class RelationshipManager {
    private FriendshipListener mFriendshipInternalListener;
    private FriendshipListener mFriendshipListener;

    private static class RelationshipManagerHolder {
        private static final RelationshipManager relationshipManager = new RelationshipManager();
    }

    public static RelationshipManager getInstance() {
        return RelationshipManager.RelationshipManagerHolder.relationshipManager;
    }

    public void init() {
        initFriendshipListener();
    }

    private void initFriendshipListener() {
        if (mFriendshipInternalListener == null) {
            mFriendshipInternalListener = new FriendshipListener() {
                @Override
                public void onSelfInfoUpdated(UserInfo userInfo) {
                    BaseManager.getInstance().notifySelfInfoUpdated(userInfo);
                }

                @Override
                public void onFriendInfoChanged(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onFriendInfoChanged(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendListAdded(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onFriendListAdded(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendListDeleted(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onFriendListDeleted(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void onBlackListAdded(final List<FriendInfo> friendInfoList) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onBlackListAdded(friendInfoList);
                            }
                        }
                    });
                }

                @Override
                public void onBlackListDeleted(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onBlackListDeleted(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendApplicationListAdded(final List<FriendApplication> applicationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onFriendApplicationListAdded(applicationList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendApplicationListDelete(final List<String> userIDList) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onFriendApplicationListDelete(userIDList);
                            }
                        }
                    });
                }

                @Override
                public void onFriendApplicationListRead() {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onFriendApplicationListRead();
                            }
                        }
                    });
                }

                @Override
                public void onUserStatusChanged(List<UserStatus> userStatusList) {
                    BaseManager.getInstance().notifyUserStatusChanged(userStatusList);
                }

                @Override
                public void onUserInfoChanged(List<UserInfo> userInfoList) {
                    BaseManager.getInstance().notifyUserInfoChanged(userInfoList);
                }

                @Override
                public void onAllReceiveMessageOptChanged(ReceiveMessageOptInfo option) {
                    BaseManager.getInstance().notifyAllReceiveMessageOptChanged(option);
                }

                @Override
                public void onMyFollowingListChanged(List<UserInfo> userInfoList, boolean isAdd) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onMyFollowingListChanged(userInfoList, isAdd);
                            }
                        }
                    });
                }

                @Override
                public void onMyFollowersListChanged(List<UserInfo> userInfoList, boolean isAdd) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onMyFollowersListChanged(userInfoList, isAdd);
                            }
                        }
                    });
                }

                @Override
                public void onMutualFollowersListChanged(List<UserInfo> userInfoList, boolean isAdd) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onMutualFollowersListChanged(userInfoList, isAdd);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountSubscribed(final OfficialAccountInfo officialAccountInfo) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onOfficialAccountSubscribed(officialAccountInfo);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountUnsubscribed(final String officialAccountID) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onOfficialAccountUnsubscribed(officialAccountID);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountDeleted(final String officialAccountID) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onOfficialAccountDeleted(officialAccountID);
                            }
                        }
                    });
                }

                @Override
                public void onOfficialAccountInfoChanged(final OfficialAccountInfo officialAccountInfo) {
                    IMContext.getInstance().runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            if (mFriendshipListener != null) {
                                mFriendshipListener.onOfficialAccountInfoChanged(officialAccountInfo);
                            }
                        }
                    });
                }
            };
        }
        nativeSetFriendshipListener(mFriendshipInternalListener);
    }

    public void setFriendshipListener(FriendshipListener friendshipListener) {
        this.mFriendshipListener = friendshipListener;
    }

    public void getUsersInfo(List<String> userIDList, IMCallback<List<UserInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetUsersInfo(userIDList, callback);
    }

    public void setSelfInfo(HashMap<String, Object> modifyParams, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetSelfInfo(modifyParams, callback);
    }

    public void subscribeUserInfo(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSubscribeUserInfo(userIDList, callback);
    }

    public void unsubscribeUserInfo(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeUnsubscribeUserInfo(userIDList, callback);
    }

    public void getUserStatus(List<String> userIDList, IMCallback<List<UserStatus>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetUserStatus(userIDList, callback);
    }

    public void setSelfStatus(UserStatus userStatus, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetSelfStatus(userStatus, callback);
    }

    public void subscribeUserStatus(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSubscribeUserStatus(userIDList, callback);
    }

    public void unsubscribeUserStatus(List<String> userIDList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeUnsubscribeUserStatus(userIDList, callback);
    }

    public void setC2CReceiveMessageOpt(List<String> userIDList, int opt, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetC2CReceiveMessageOpt(userIDList, opt, callback);
    }

    public void getC2CReceiveMessageOpt(List<String> userIDList, IMCallback<List<ReceiveMessageOptInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetC2CReceiveMessageOpt(userIDList, callback);
    }

    public void setAllReceiveMessageOpt(
        int opt, int startHour, int startMinute, int startSecond, long duration, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetAllReceiveMessageOpt(opt, startHour, startMinute, startSecond, 0, duration, callback);
    }

    public void setAllReceiveMessageOpt(int opt, long startTimeStamp, long duration, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetAllReceiveMessageOpt(opt, 0, 0, 0, startTimeStamp, duration, callback);
    }

    public void getAllReceiveMessageOpt(IMCallback<ReceiveMessageOptInfo> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetAllReceiveMessageOpt(callback);
    }

    public void getFriendList(IMCallback<List<FriendInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetFriendList(callback);
    }

    public void getFriendsInfo(List<String> userIDList, IMCallback<List<FriendInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetFriendsInfo(userIDList, callback);
    }

    public void setFriendInfo(String userID, HashMap<String, Object> modifyParams, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetFriendInfo(userID, modifyParams, callback);
    }

    public void searchFriends(FriendSearchParam searchParam, IMCallback<List<FriendInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSearchFriends(searchParam, callback);
    }

    public void addFriend(FriendAddApplication friendAddApplication, IMCallback<FriendOperationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeAddFriend(friendAddApplication, callback);
    }

    public void deleteFromFriendList(
        List<String> userIDList, int deleteType, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDeleteFromFriendList(userIDList, deleteType, callback);
    }

    public void checkFriend(List<String> userIDList, int checkType, IMCallback<List<FriendCheckResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeCheckFriend(userIDList, checkType, callback);
    }

    public void getFriendApplicationList(IMCallback<FriendApplicationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetFriendApplicationList(callback);
    }

    public void responseFriendApplication(FriendResponse friendResponse, IMCallback<FriendOperationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeResponseFriendApplication(friendResponse, callback);
    }

    public void deleteFriendApplication(int applicationType, String userID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDeleteFriendApplication(applicationType, userID, callback);
    }

    public void setFriendApplicationRead(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetFriendApplicationRead(callback);
    }

    public void addToBlackList(List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeAddToBlackList(userIDList, callback);
    }

    public void deleteFromBlackList(List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDeleteFromBlackList(userIDList, callback);
    }

    public void getBlackList(IMCallback<List<FriendInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetBlackList(callback);
    }

    public void createFriendGroup(
        String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeCreateFriendGroup(groupName, userIDList, callback);
    }

    public void getFriendGroups(List<String> groupNameList, IMCallback<List<FriendGroup>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetFriendGroups(groupNameList, callback);
    }

    public void deleteFriendGroup(List<String> groupNameList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDeleteFriendGroup(groupNameList, callback);
    }

    public void renameFriendGroup(String oldName, String newName, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeRenameFriendGroup(oldName, newName, callback);
    }

    public void addFriendsToFriendGroup(
        String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeAddFriendsToFriendGroup(groupName, userIDList, callback);
    }

    public void deleteFriendsFromFriendGroup(
        String groupName, List<String> userIDList, IMCallback<List<FriendOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDeleteFriendsFromFriendGroup(groupName, userIDList, callback);
    }

    public void followUser(List<String> userIDList, IMCallback<List<FollowOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeFollowUser(userIDList, callback);
    }

    public void unfollowUser(List<String> userIDList, IMCallback<List<FollowOperationResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeUnfollowUser(userIDList, callback);
    }

    public void getMyFollowingList(String nextCursor, IMCallback<UserInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetMyFollowingList(nextCursor, callback);
    }

    public void getMyFollowersList(String nextCursor, IMCallback<UserInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetMyFollowersList(nextCursor, callback);
    }

    public void getMutualFollowersList(String nextCursor, IMCallback<UserInfoResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetMutualFollowersList(nextCursor, callback);
    }

    public void getUserFollowInfo(List<String> userIDList, IMCallback<List<FollowInfo>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetUserFollowInfo(userIDList, callback);
    }

    public void checkFollowType(List<String> userIDList, IMCallback<List<FollowTypeCheckResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeCheckFollowType(userIDList, callback);
    }

    public void subscribeOfficialAccount(String officialAccountID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSubscribeOfficialAccount(officialAccountID, callback);
    }

    public void unsubscribeOfficialAccount(String officialAccountID, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeUnsubscribeOfficialAccount(officialAccountID, callback);
    }

    public void getOfficialAccountsInfo(
        List<String> officialAccountIDList, IMCallback<List<OfficialAccountInfoResult>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetOfficialAccountsInfo(officialAccountIDList, callback);
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    protected native void nativeSetFriendshipListener(FriendshipListener friendshipListener);

    protected native void nativeGetUsersInfo(List<String> userIDList, final IMCallback<List<UserInfo>> callback);

    protected native void nativeSetSelfInfo(HashMap<String, Object> modifyParams, final IMCallback callback);

    protected native void nativeSubscribeUserInfo(List<String> userIDList, final IMCallback callback);

    protected native void nativeUnsubscribeUserInfo(List<String> userIDList, final IMCallback callback);

    protected native void nativeGetUserStatus(List<String> userIDList, final IMCallback<List<UserStatus>> callback);

    protected native void nativeSetSelfStatus(UserStatus userStatus, final IMCallback callback);

    protected native void nativeSubscribeUserStatus(List<String> userIDList, final IMCallback callback);

    protected native void nativeUnsubscribeUserStatus(List<String> userIDList, final IMCallback callback);

    protected native void nativeSetC2CReceiveMessageOpt(List<String> userIDList, int opt, IMCallback callback);

    protected native void nativeGetC2CReceiveMessageOpt(
        List<String> userIDList, IMCallback<List<ReceiveMessageOptInfo>> callback);

    protected native void nativeSetAllReceiveMessageOpt(int opt, int startHour, int startMinute, int startSecond,
        long startTimeStamp, long duration, final IMCallback callback);

    protected native void nativeGetAllReceiveMessageOpt(final IMCallback<ReceiveMessageOptInfo> callback);

    protected native void nativeGetFriendList(IMCallback callback);

    protected native void nativeGetFriendsInfo(List<String> userIDList, IMCallback callback);

    protected native void nativeSetFriendInfo(String userID, HashMap<String, Object> modifyParams, IMCallback callback);

    protected native void nativeSearchFriends(FriendSearchParam param, IMCallback callback);

    protected native void nativeAddFriend(FriendAddApplication friendAddApplication, IMCallback callback);

    protected native void nativeDeleteFromFriendList(List<String> userIDList, int deleteType, IMCallback callback);

    protected native void nativeCheckFriend(List<String> userIDList, int checkType, IMCallback callback);

    protected native void nativeGetFriendApplicationList(IMCallback callback);

    protected native void nativeResponseFriendApplication(FriendResponse friendResponse, IMCallback callback);

    protected native void nativeDeleteFriendApplication(int applicationType, String userID, IMCallback callback);

    protected native void nativeSetFriendApplicationRead(IMCallback callback);

    protected native void nativeAddToBlackList(List<String> userIDList, IMCallback callback);

    protected native void nativeDeleteFromBlackList(List<String> userIDList, IMCallback callback);

    protected native void nativeGetBlackList(IMCallback callback);

    protected native void nativeCreateFriendGroup(String groupName, List<String> userIDList, IMCallback callback);

    protected native void nativeGetFriendGroups(List<String> groupNameList, IMCallback callback);

    protected native void nativeDeleteFriendGroup(List<String> groupNameList, IMCallback callback);

    protected native void nativeRenameFriendGroup(String oldName, String newName, IMCallback callback);

    protected native void nativeAddFriendsToFriendGroup(String groupName, List<String> userIDList, IMCallback callback);

    protected native void nativeDeleteFriendsFromFriendGroup(
        String groupName, List<String> userIDList, IMCallback callback);

    protected native void nativeFollowUser(List<String> userIDList, IMCallback<List<FollowOperationResult>> callback);

    protected native void nativeUnfollowUser(List<String> userIDList, IMCallback<List<FollowOperationResult>> callback);

    protected native void nativeGetMyFollowingList(String nextCursor, IMCallback<UserInfoResult> callback);

    protected native void nativeGetMyFollowersList(String nextCursor, IMCallback<UserInfoResult> callback);

    protected native void nativeGetMutualFollowersList(String nextCursor, IMCallback<UserInfoResult> callback);

    protected native void nativeGetUserFollowInfo(List<String> userIDList, IMCallback<List<FollowInfo>> callback);

    protected native void nativeCheckFollowType(
        List<String> userIDList, IMCallback<List<FollowTypeCheckResult>> callback);

    protected native void nativeSubscribeOfficialAccount(String officialAccountID, IMCallback callback);

    protected native void nativeUnsubscribeOfficialAccount(String officialAccountID, IMCallback callback);

    protected native void nativeGetOfficialAccountsInfo(List<String> officialAccountIDList, IMCallback callback);
}
