package com.tencent.imsdk.relationship;

import android.text.TextUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class FriendAddApplication implements Serializable {
    private String userID;
    private byte[] remarkBytes;
    private byte[] groupNameBytes;
    private byte[] addWordingBytes;
    private byte[] addSourceBytes;
    private int addType;

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setRemark(String remark) {
        if (!TextUtils.isEmpty(remark)) {
            try {
                this.remarkBytes = remark.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void setGroupName(String groupName) {
        if (!TextUtils.isEmpty(groupName)) {
            try {
                this.groupNameBytes = groupName.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void setAddWording(String addWording) {
        if (!TextUtils.isEmpty(addWording)) {
            try {
                this.addWordingBytes = addWording.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void setAddSource(String addSource) {
        if (!TextUtils.isEmpty(addSource)) {
            try {
                this.addSourceBytes = addSource.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void setAddType(int addType) {
        this.addType = addType;
    }
}
