package com.tencent.imsdk.message;

import com.tencent.imsdk.v2.V2TIMMessage;

public class ImageElement extends MessageBaseElement {
    private int imageFormat;
    private int compressType;

    private String originImageUUID;
    private String originImageUrl;
    private String originImageFilePath;
    private int originImageFileSize;
    private int originImageWidth;
    private int originImageHeight;

    private String thumbImageUUID;
    private String thumbImageUrl;
    private int thumbImageFileSize;
    private int thumbImageWidth;
    private int thumbImageHeight;

    private String largeImageUUID;
    private String largeImageUrl;
    private int largeImageFileSize;
    private int largeImageWidth;
    private int largeImageHeight;

    public ImageElement() {
        setElementType(V2TIMMessage.V2TIM_ELEM_TYPE_IMAGE);
    }

    public int getImageFormat() {
        return imageFormat;
    }

    public int getCompressType() {
        return compressType;
    }

    public String getOriginImageUUID() {
        return originImageUUID;
    }

    public String getOriginImageUrl() {
        return originImageUrl;
    }

    public String getOriginImageFilePath() {
        return originImageFilePath;
    }

    public void setOriginImageFilePath(String filePath) {
        this.originImageFilePath = filePath;
    }

    public int getOriginImageFileSize() {
        return originImageFileSize;
    }

    public int getOriginImageWidth() {
        return originImageWidth;
    }

    public int getOriginImageHeight() {
        return originImageHeight;
    }

    public String getThumbImageUUID() {
        return thumbImageUUID;
    }

    public String getThumbImageUrl() {
        return thumbImageUrl;
    }

    public int getThumbImageFileSize() {
        return thumbImageFileSize;
    }

    public int getThumbImageWidth() {
        return thumbImageWidth;
    }

    public int getThumbImageHeight() {
        return thumbImageHeight;
    }

    public String getLargeImageUUID() {
        return largeImageUUID;
    }

    public String getLargeImageUrl() {
        return largeImageUrl;
    }

    public int getLargeImageFileSize() {
        return largeImageFileSize;
    }

    public int getLargeImageWidth() {
        return largeImageWidth;
    }

    public int getLargeImageHeight() {
        return largeImageHeight;
    }

    @Override
    public boolean update(MessageBaseElement element) {
        if (elementType == element.elementType) {
            ImageElement imageElement = (ImageElement) element;
            if (originImageFilePath.equals(imageElement.originImageFilePath)) {
                imageFormat = imageElement.imageFormat;
                compressType = imageElement.compressType;

                originImageUUID = imageElement.originImageUUID;
                originImageUrl = imageElement.originImageUrl;
                originImageFileSize = imageElement.originImageFileSize;
                originImageWidth = imageElement.originImageWidth;
                originImageHeight = imageElement.originImageHeight;

                thumbImageUUID = imageElement.thumbImageUUID;
                thumbImageUrl = imageElement.thumbImageUrl;
                thumbImageFileSize = imageElement.thumbImageFileSize;
                thumbImageWidth = imageElement.thumbImageWidth;
                thumbImageHeight = imageElement.thumbImageHeight;

                largeImageUUID = imageElement.largeImageUUID;
                largeImageUrl = imageElement.largeImageUrl;
                largeImageFileSize = imageElement.largeImageFileSize;
                largeImageWidth = imageElement.largeImageWidth;
                largeImageHeight = imageElement.largeImageHeight;

                return true;
            }
        }

        return false;
    }
}
