package com.tencent.imsdk.conversation;

import android.text.TextUtils;
import java.io.Serializable;

public class ConversationListFilter implements Serializable {
    /**
     * 不过滤
     */
    public static final int TIM_CONVERSATION_FILTER_TYPE_NONE = 0;
    /**
     * 会话标记过滤
     */
    public static final int TIM_CONVERSATION_FILTER_TYPE_CONVERSATION_MARK = 0x1;
    /**
     * 会话分组过滤
     */
    public static final int TIM_CONVERSATION_FILTER_TYPE_CONVERSATION_GROUP = 0x1 << 1;
    /**
     * 会话未读数过滤
     */
    public static final int TIM_CONVERSATION_FILTER_TYPE_HAS_UNREAD_COUNT = 0x1 << 2;
    /**
     * 群 @ 信息过滤
     */
    public static final int TIM_CONVERSATION_FILTER_TYPE_HAS_GROUP_AT_INFO = 0x1 << 3;

    private int conversationType = 0;
    private int filterType = TIM_CONVERSATION_FILTER_TYPE_NONE;
    private String conversationGroup;
    private long markType = 0;
    private boolean hasUnreadCount;
    private boolean hasGroupAtInfo;

    public int getConversationType() {
        return this.conversationType;
    }

    public void setConversationType(int conversationType) {
        this.conversationType = conversationType;
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public String getConversationGroup() {
        return this.conversationGroup;
    }

    public void setConversationGroup(String groupName) {
        this.conversationGroup = groupName;
        this.filterType |= TIM_CONVERSATION_FILTER_TYPE_CONVERSATION_GROUP;
    }

    public long getMarkType() {
        return this.markType;
    }

    public void setMarkType(long markType) {
        this.markType = markType;
        this.filterType |= TIM_CONVERSATION_FILTER_TYPE_CONVERSATION_MARK;
    }

    public boolean getHasUnreadCount() {
        return this.hasUnreadCount;
    }

    public void setHasUnreadCount(boolean hasUnreadCount) {
        this.hasUnreadCount = hasUnreadCount;
        this.filterType |= TIM_CONVERSATION_FILTER_TYPE_HAS_UNREAD_COUNT;
    }

    public boolean getHasGroupAtInfo() {
        return this.hasGroupAtInfo;
    }

    public void setHasGroupAtInfo(boolean hasGroupAtInfo) {
        this.hasGroupAtInfo = hasGroupAtInfo;
        this.filterType |= TIM_CONVERSATION_FILTER_TYPE_HAS_GROUP_AT_INFO;
    }

    public boolean isNull() {
        return (0 == this.conversationType && TIM_CONVERSATION_FILTER_TYPE_NONE == this.filterType);
    }
}
