package com.tencent.imsdk.community;

import java.util.HashMap;
import java.util.List;

public abstract class CommunityListener {
    /**
     * 话题创建
     *
     * @param topicID 话题 ID
     */
    public void onCreateTopic(String groupID, String topicID) {}

    /**
     * 话题被删除
     * @param groupID 话题所属的社群 ID
     * @param topicIDList 话题列表
     */
    public void onDeleteTopic(String groupID, List<String> topicIDList) {}

    /**
     * 话题更新
     * @param topicInfo 话题信息
     */
    public void onChangeTopicInfo(String groupID, TopicInfo topicInfo) {}

    /**
     * 收到 RESTAPI 下发的自定义系统消息
     *
     * @param topicID    话题 ID
     * @param customData 自定义数据
     */
    public void onReceiveTopicRESTCustomData(String topicID, byte[] customData) {}

    /**
     * 权限组创建通知
     */
    public void onCreatePermissionGroup(String groupID, PermissionGroupInfo permissionGroupInfo) {}

    /**
     * 权限组删除通知
     */
    public void onDeletePermissionGroup(String groupID, List<String> permissionGroupIDList) {}

    /**
     * 权限组资料更新通知
     */
    public void onChangePermissionGroupInfo(String groupID, PermissionGroupInfo permissionGroupInfo) {}

    /**
     * 添加成员到权限组中的通知
     */
    public void onAddMembersToPermissionGroup(String groupID, String permissionGroupID, List<String> memberIDList) {}

    /**
     * 从权限组中删除成员的通知
     */
    public void onRemoveMembersFromPermissionGroup(
        String groupID, String permissionGroupID, List<String> memberIDList) {}

    /**
     * 增加话题权限到权限组中通知
     */
    public void onAddTopicPermission(
        String groupID, String permissionGroupID, HashMap<String, Long> topicPermissionMap) {}

    /**
     * 从权限组删除的话题权限通知
     */
    public void onDeleteTopicPermission(String groupID, String permissionGroupID, List<String> topicIDList) {}

    /**
     * 权限组中的话题权限修改通知
     */
    public void onModifyTopicPermission(
        String groupID, String permissionGroupID, HashMap<String, Long> topicPermissionMap) {}
}
