/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import shark.HeapGraph;
import shark.HeapObject;
import shark.HprofRecord;
import shark.IgnoredReferenceMatcher;
import shark.LibraryLeakReferenceMatcher;
import shark.PrimitiveType;
import shark.ReferenceMatcher;
import shark.ReferenceMatcherKt;
import shark.ReferencePattern;
import shark.internal.FieldIdReader;
import shark.internal.FieldInstanceReferenceReader;
import shark.internal.Reference;
import shark.internal.ReferenceLocationType;
import shark.internal.ReferenceReader;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006*\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u0018\u001a\u00020\u000f*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lshark/internal/FieldInstanceReferenceReader;", "Lshark/internal/ReferenceReader;", "Lshark/HeapObject$HeapInstance;", "graph", "Lshark/HeapGraph;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "(Lshark/HeapGraph;Ljava/util/List;)V", "fieldNameByClassName", "", "", "javaLangObjectId", "", "sizeOfObjectInstances", "", "determineSizeOfObjectInstances", "objectClass", "Lshark/HeapObject$HeapClass;", "read", "Lkotlin/sequences/Sequence;", "Lshark/internal/Reference;", "source", "classHierarchyWithoutJavaLangObject", "getRecordSize", "field", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord$FieldRecord;", "shark"})
public final class FieldInstanceReferenceReader
implements ReferenceReader<HeapObject.HeapInstance> {
    private final Map<String, Map<String, ReferenceMatcher>> fieldNameByClassName;
    private final long javaLangObjectId;
    private final int sizeOfObjectInstances;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<Reference> read(@NotNull HeapObject.HeapInstance source) {
        Comparator comparator;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        if (source.isPrimitiveWrapper() || Intrinsics.areEqual((Object)source.getInstanceClassName(), (Object)"java.lang.String") || source.getInstanceClass().getInstanceByteSize() <= this.sizeOfObjectInstances) {
            return SequencesKt.emptySequence();
        }
        LinkedHashMap fieldReferenceMatchers = new LinkedHashMap();
        List<HeapObject.HeapClass> classHierarchy = this.classHierarchyWithoutJavaLangObject(source.getInstanceClass(), this.javaLangObjectId);
        Iterable $this$forEach$iv = classHierarchy;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapObject.HeapClass it = (HeapObject.HeapClass)element$iv;
            boolean bl = false;
            Map<String, ReferenceMatcher> referenceMatcherByField = this.fieldNameByClassName.get(it.getName());
            if (referenceMatcherByField == null) continue;
            Object object = referenceMatcherByField;
            boolean bl2 = false;
            for (Map.Entry<String, ReferenceMatcher> entry : object.entrySet()) {
                void fieldName;
                Object object2 = entry;
                boolean bl3 = false;
                object = object2.getKey();
                object2 = entry;
                bl3 = false;
                ReferenceMatcher referenceMatcher = object2.getValue();
                if (fieldReferenceMatchers.containsKey(fieldName)) continue;
                ((Map)fieldReferenceMatchers).put(fieldName, referenceMatcher);
            }
        }
        boolean bl = false;
        boolean bl4 = false;
        HeapObject.HeapInstance $this$with = source;
        boolean bl5 = false;
        HeapGraph hprofGraph = $this$with.getGraph();
        Object var9_12 = null;
        Lazy fieldReader2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<FieldIdReader>($this$with, hprofGraph){
            final /* synthetic */ HeapObject.HeapInstance $this_with;
            final /* synthetic */ HeapGraph $hprofGraph;

            @NotNull
            public final FieldIdReader invoke() {
                return new FieldIdReader(this.$this_with.readRecord(), this.$hprofGraph.getIdentifierByteSize());
            }
            {
                this.$this_with = heapInstance;
                this.$hprofGraph = heapGraph;
                super(0);
            }
        }));
        boolean fieldName = false;
        List result = new ArrayList();
        int skipBytesCount = 0;
        for (HeapObject.HeapClass heapClass : classHierarchy) {
            for (HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord fieldRecord : heapClass.readRecordFields()) {
                String name;
                ReferenceMatcher referenceMatcher;
                if (fieldRecord.getType() != 2) {
                    skipBytesCount += this.getRecordSize(hprofGraph, fieldRecord);
                    continue;
                }
                comparator = fieldReader2;
                Object var18_29 = null;
                boolean bl6 = false;
                ((FieldIdReader)comparator.getValue()).skipBytes(skipBytesCount);
                skipBytesCount = 0;
                Lazy lazy = fieldReader2;
                Object var20_32 = null;
                boolean bl7 = false;
                long valueObjectId = ((FieldIdReader)lazy.getValue()).readId();
                if (valueObjectId == 0L || (referenceMatcher = (ReferenceMatcher)fieldReferenceMatchers.get(name = heapClass.instanceFieldName(fieldRecord))) instanceof IgnoredReferenceMatcher) continue;
                long locationClassObjectId = heapClass.getObjectId();
                result.add(TuplesKt.to((Object)name, (Object)new Reference(valueObjectId, referenceMatcher != null, new Reference.LazyDetails.Resolver(name, locationClassObjectId, referenceMatcher){
                    final /* synthetic */ String $name;
                    final /* synthetic */ long $locationClassObjectId;
                    final /* synthetic */ ReferenceMatcher $referenceMatcher;

                    @NotNull
                    public final Reference.LazyDetails resolve() {
                        return new Reference.LazyDetails(this.$name, this.$locationClassObjectId, ReferenceLocationType.INSTANCE_FIELD, (LibraryLeakReferenceMatcher)this.$referenceMatcher, false);
                    }
                    {
                        this.$name = string;
                        this.$locationClassObjectId = l;
                        this.$referenceMatcher = referenceMatcher;
                    }
                })));
            }
        }
        List $this$sortBy$iv = result;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            List list = $this$sortBy$iv;
            boolean bl8 = false;
            comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Pair it = (Pair)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = (String)it.getFirst();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)comparator);
        }
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)result), (Function1)read.2.3.INSTANCE);
    }

    private final List<HeapObject.HeapClass> classHierarchyWithoutJavaLangObject(HeapObject.HeapClass $this$classHierarchyWithoutJavaLangObject, long javaLangObjectId) {
        boolean bl = false;
        List result = new ArrayList();
        for (HeapObject.HeapClass parent = $this$classHierarchyWithoutJavaLangObject; parent != null && parent.getObjectId() != javaLangObjectId; parent = parent.getSuperclass()) {
            Collection collection = result;
            boolean bl2 = false;
            collection.add(parent);
        }
        return result;
    }

    private final int getRecordSize(HeapGraph $this$getRecordSize, HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord field) {
        int n;
        int n2 = field.getType();
        if (n2 == 2) {
            n = $this$getRecordSize.getIdentifierByteSize();
        } else if (n2 == PrimitiveType.BOOLEAN.getHprofType()) {
            n = 1;
        } else if (n2 == PrimitiveType.CHAR.getHprofType()) {
            n = 2;
        } else if (n2 == PrimitiveType.FLOAT.getHprofType()) {
            n = 4;
        } else if (n2 == PrimitiveType.DOUBLE.getHprofType()) {
            n = 8;
        } else if (n2 == PrimitiveType.BYTE.getHprofType()) {
            n = 1;
        } else if (n2 == PrimitiveType.SHORT.getHprofType()) {
            n = 2;
        } else if (n2 == PrimitiveType.INT.getHprofType()) {
            n = 4;
        } else if (n2 == PrimitiveType.LONG.getHprofType()) {
            n = 8;
        } else {
            throw (Throwable)new IllegalStateException("Unknown type " + field.getType());
        }
        return n;
    }

    private final int determineSizeOfObjectInstances(HeapObject.HeapClass objectClass, HeapGraph graph) {
        int sizeOfObjectOnArt;
        int objectClassFieldSize;
        return objectClass != null ? ((objectClassFieldSize = objectClass.readFieldsByteSize()) == (sizeOfObjectOnArt = graph.getIdentifierByteSize() + PrimitiveType.INT.getByteSize()) ? sizeOfObjectOnArt : 0) : 0;
    }

    public FieldInstanceReferenceReader(@NotNull HeapGraph graph, @NotNull List<? extends ReferenceMatcher> referenceMatchers) {
        HeapObject.HeapClass objectClass;
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        HeapObject.HeapClass heapClass = objectClass = graph.findClassByName("java.lang.Object");
        this.javaLangObjectId = heapClass != null ? heapClass.getObjectId() : -1L;
        this.sizeOfObjectInstances = this.determineSizeOfObjectInstances(objectClass, graph);
        boolean bl = false;
        Map fieldNameByClassName = new LinkedHashMap();
        Iterable $this$forEach$iv = ReferenceMatcherKt.filterFor((Iterable<? extends ReferenceMatcher>)referenceMatchers, graph);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map;
            ReferenceMatcher referenceMatcher = (ReferenceMatcher)element$iv;
            boolean bl2 = false;
            ReferencePattern pattern = referenceMatcher.getPattern();
            if (!(pattern instanceof ReferencePattern.InstanceFieldPattern)) continue;
            Map mapOrNull = (Map)fieldNameByClassName.get(((ReferencePattern.InstanceFieldPattern)pattern).getClassName());
            if (mapOrNull != null) {
                map = mapOrNull;
            } else {
                boolean bl3 = false;
                Map newMap = new LinkedHashMap();
                fieldNameByClassName.put(((ReferencePattern.InstanceFieldPattern)pattern).getClassName(), newMap);
                map = newMap;
            }
            Map map2 = map;
            map2.put(((ReferencePattern.InstanceFieldPattern)pattern).getFieldName(), referenceMatcher);
        }
        this.fieldNameByClassName = fieldNameByClassName;
    }
}

