/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.HeapField;
import shark.HeapGraph;
import shark.HeapObject;
import shark.IgnoredReferenceMatcher;
import shark.LibraryLeakReferenceMatcher;
import shark.ReferenceMatcher;
import shark.ReferenceMatcherKt;
import shark.ReferencePattern;
import shark.ValueHolder;
import shark.internal.Reference;
import shark.internal.ReferenceLocationType;
import shark.internal.ReferenceReader;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lshark/internal/ClassReferenceReader;", "Lshark/internal/ReferenceReader;", "Lshark/HeapObject$HeapClass;", "graph", "Lshark/HeapGraph;", "referenceMatchers", "", "Lshark/ReferenceMatcher;", "(Lshark/HeapGraph;Ljava/util/List;)V", "staticFieldNameByClassName", "", "", "read", "Lkotlin/sequences/Sequence;", "Lshark/internal/Reference;", "source", "shark"})
public final class ClassReferenceReader
implements ReferenceReader<HeapObject.HeapClass> {
    private final Map<String, Map<String, ReferenceMatcher>> staticFieldNameByClassName;

    @Override
    @NotNull
    public Sequence<Reference> read(@NotNull HeapObject.HeapClass source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Map map = this.staticFieldNameByClassName.get(source.getName());
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map ignoredStaticFields = map;
        return SequencesKt.mapNotNull((Sequence)source.readStaticFields(), (Function1)((Function1)new Function1<HeapField, Reference>(ignoredStaticFields, source){
            final /* synthetic */ Map $ignoredStaticFields;
            final /* synthetic */ HeapObject.HeapClass $source;

            @Nullable
            public final Reference invoke(@NotNull HeapField staticField) {
                Reference reference;
                Intrinsics.checkParameterIsNotNull((Object)staticField, (String)"staticField");
                if (!staticField.getValue().isNonNullReference()) {
                    return null;
                }
                String fieldName = staticField.getName();
                if (Intrinsics.areEqual((Object)fieldName, (Object)"$staticOverhead") || Intrinsics.areEqual((Object)fieldName, (Object)"$classOverhead")) {
                    return null;
                }
                ValueHolder valueHolder = staticField.getValue().getHolder();
                if (valueHolder == null) {
                    throw new TypeCastException("null cannot be cast to non-null type shark.ValueHolder.ReferenceHolder");
                }
                long valueObjectId = ((ValueHolder.ReferenceHolder)valueHolder).getValue();
                ReferenceMatcher referenceMatcher = (ReferenceMatcher)this.$ignoredStaticFields.get(fieldName);
                if (referenceMatcher instanceof IgnoredReferenceMatcher) {
                    reference = null;
                } else {
                    long sourceObjectId = this.$source.getObjectId();
                    reference = new Reference(valueObjectId, referenceMatcher != null, new Reference.LazyDetails.Resolver(fieldName, sourceObjectId, referenceMatcher){
                        final /* synthetic */ String $fieldName;
                        final /* synthetic */ long $sourceObjectId;
                        final /* synthetic */ ReferenceMatcher $referenceMatcher;

                        @NotNull
                        public final Reference.LazyDetails resolve() {
                            LibraryLeakReferenceMatcher libraryLeakReferenceMatcher = (LibraryLeakReferenceMatcher)this.$referenceMatcher;
                            boolean bl = false;
                            return new Reference.LazyDetails(this.$fieldName, this.$sourceObjectId, ReferenceLocationType.STATIC_FIELD, libraryLeakReferenceMatcher, bl);
                        }
                        {
                            this.$fieldName = string;
                            this.$sourceObjectId = l;
                            this.$referenceMatcher = referenceMatcher;
                        }
                    });
                }
                return reference;
            }
            {
                this.$ignoredStaticFields = map;
                this.$source = heapClass;
                super(1);
            }
        }));
    }

    public ClassReferenceReader(@NotNull HeapGraph graph, @NotNull List<? extends ReferenceMatcher> referenceMatchers) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull(referenceMatchers, (String)"referenceMatchers");
        boolean bl = false;
        Map staticFieldNameByClassName = new LinkedHashMap();
        Iterable $this$forEach$iv = ReferenceMatcherKt.filterFor((Iterable<? extends ReferenceMatcher>)referenceMatchers, graph);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map;
            ReferenceMatcher referenceMatcher = (ReferenceMatcher)element$iv;
            boolean bl2 = false;
            ReferencePattern pattern = referenceMatcher.getPattern();
            if (!(pattern instanceof ReferencePattern.StaticFieldPattern)) continue;
            Map mapOrNull = (Map)staticFieldNameByClassName.get(((ReferencePattern.StaticFieldPattern)pattern).getClassName());
            if (mapOrNull != null) {
                map = mapOrNull;
            } else {
                boolean bl3 = false;
                Map newMap = new LinkedHashMap();
                staticFieldNameByClassName.put(((ReferencePattern.StaticFieldPattern)pattern).getClassName(), newMap);
                map = newMap;
            }
            Map map2 = map;
            map2.put(((ReferencePattern.StaticFieldPattern)pattern).getFieldName(), referenceMatcher);
        }
        this.staticFieldNameByClassName = staticFieldNameByClassName;
    }
}

