/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.junit.FailuresSupplier;
import com.palantir.gradle.junit.JunitTaskResultExtension;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JunitTaskResultExtension.TaskEntry", generator="Immutables")
@Immutable
final class ImmutableTaskEntry
implements JunitTaskResultExtension.TaskEntry {
    private final String name;
    private final FailuresSupplier failuresSupplier;

    private ImmutableTaskEntry(String name, FailuresSupplier failuresSupplier) {
        this.name = name;
        this.failuresSupplier = failuresSupplier;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public FailuresSupplier failuresSupplier() {
        return this.failuresSupplier;
    }

    public final ImmutableTaskEntry withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTaskEntry(newValue, this.failuresSupplier);
    }

    public final ImmutableTaskEntry withFailuresSupplier(FailuresSupplier value) {
        if (this.failuresSupplier == value) {
            return this;
        }
        FailuresSupplier newValue = Objects.requireNonNull(value, "failuresSupplier");
        return new ImmutableTaskEntry(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskEntry && this.equalTo((ImmutableTaskEntry)another);
    }

    private boolean equalTo(ImmutableTaskEntry another) {
        return this.name.equals(another.name) && this.failuresSupplier.equals(another.failuresSupplier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.failuresSupplier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskEntry").omitNullValues().add("name", (Object)this.name).add("failuresSupplier", (Object)this.failuresSupplier).toString();
    }

    public static ImmutableTaskEntry copyOf(JunitTaskResultExtension.TaskEntry instance) {
        if (instance instanceof ImmutableTaskEntry) {
            return (ImmutableTaskEntry)instance;
        }
        return ImmutableTaskEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JunitTaskResultExtension.TaskEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_FAILURES_SUPPLIER = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private FailuresSupplier failuresSupplier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JunitTaskResultExtension.TaskEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.failuresSupplier(instance.failuresSupplier());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder failuresSupplier(FailuresSupplier failuresSupplier) {
            this.failuresSupplier = Objects.requireNonNull(failuresSupplier, "failuresSupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTaskEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskEntry(this.name, this.failuresSupplier);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("failuresSupplier");
            }
            return "Cannot build TaskEntry, some of required attributes are not set " + attributes;
        }
    }
}

