/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.TaskTimer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Predicate;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.tasks.TaskState;

public final class DefaultTaskTimer
implements TaskTimer,
TaskExecutionListener {
    private final Map<Task, Timer> taskTimers = new LinkedHashMap<Task, Timer>();
    private final Predicate<Task> isTrackedTask;

    public DefaultTaskTimer(Predicate<Task> isTrackedTask) {
        this.isTrackedTask = isTrackedTask;
    }

    @Override
    public long getTaskTimeNanos(Task task) {
        return Optional.ofNullable(this.taskTimers.get(task)).map(Timer::getElapsed).orElseThrow(() -> new IllegalArgumentException("No time available for task " + task.getName()));
    }

    public void beforeExecute(Task task) {
        if (this.isTrackedTask.test(task)) {
            this.taskTimers.put(task, new Timer());
        }
    }

    public void afterExecute(Task task, TaskState _taskState) {
        Optional.ofNullable(this.taskTimers.get(task)).ifPresent(Timer::stop);
    }

    static final class Timer {
        private final long startTime = System.nanoTime();
        private OptionalLong endTime = OptionalLong.empty();

        Timer() {
        }

        void stop() {
            this.endTime = OptionalLong.of(System.nanoTime());
        }

        long getElapsed() {
            if (this.endTime.isPresent()) {
                return this.endTime.getAsLong() - this.startTime;
            }
            return 0L;
        }
    }
}

