/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.palantir.gradle.junit.TaskTimer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.tasks.TaskState;
import org.gradle.api.tasks.compile.JavaCompile;

public final class StyleTaskTimer
implements TaskTimer {
    private final Map<Task, Long> taskTimeNanosByTask = new LinkedHashMap<Task, Long>();
    private long lastStartTime;

    @Override
    public long getTaskTimeNanos(Task styleTask) {
        if (!StyleTaskTimer.isStyleTask(styleTask)) {
            throw new ClassCastException("not a style task");
        }
        Long taskTimeNanos = this.taskTimeNanosByTask.get(styleTask);
        if (taskTimeNanos == null) {
            throw new IllegalArgumentException("no time available for task");
        }
        return taskTimeNanos;
    }

    public void beforeExecute(Task task) {
        if (StyleTaskTimer.isStyleTask(task)) {
            this.lastStartTime = System.nanoTime();
        }
    }

    public void afterExecute(Task task, TaskState taskState) {
        if (StyleTaskTimer.isStyleTask(task)) {
            this.taskTimeNanosByTask.put(task, System.nanoTime() - this.lastStartTime);
        }
    }

    public static boolean isStyleTask(Task task) {
        return task instanceof Checkstyle || task instanceof JavaCompile;
    }
}

