/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.base.Splitter;
import com.palantir.gradle.junit.BuildFailureListener;
import com.palantir.gradle.junit.BuildFinishedAction;
import com.palantir.gradle.junit.CheckstyleReportHandler;
import com.palantir.gradle.junit.JavacFailuresSupplier;
import com.palantir.gradle.junit.JunitReportsExtension;
import com.palantir.gradle.junit.JunitReportsFinalizer;
import com.palantir.gradle.junit.StyleTaskTimer;
import com.palantir.gradle.junit.XmlReportFailuresSupplier;
import java.io.File;
import java.nio.file.Path;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;

public final class JunitReportsPlugin
implements Plugin<Project> {
    public static final String EXT_JUNIT_REPORTS = "junitReports";

    public void apply(Project project) {
        if (project != project.getRootProject()) {
            project.getLogger().warn("com.palantir.junit-reports should be applied to the root project only, not '{}'", (Object)project.getName());
        }
        JunitReportsExtension reportsExtension = (JunitReportsExtension)project.getExtensions().create(EXT_JUNIT_REPORTS, JunitReportsExtension.class, new Object[]{project});
        JunitReportsPlugin.configureBuildFailureFinalizer(project.getRootProject(), (Provider<Directory>)reportsExtension.getReportsDirectory());
        StyleTaskTimer timer = new StyleTaskTimer();
        project.getRootProject().getGradle().addListener((Object)timer);
        project.getRootProject().allprojects(proj -> {
            proj.getTasks().withType(Test.class, test -> {
                test.getReports().getJunitXml().setEnabled(true);
                test.getReports().getJunitXml().setDestination(JunitReportsPlugin.junitPath(reportsExtension.getReportsDirectory(), test.getPath()));
            });
            proj.getTasks().withType(Checkstyle.class, checkstyle -> JunitReportsFinalizer.registerFinalizer((Task)checkstyle, timer, XmlReportFailuresSupplier.create(checkstyle, new CheckstyleReportHandler()), (Provider<Directory>)reportsExtension.getReportsDirectory().map(dir -> dir.dir("checkstyle"))));
            proj.getTasks().withType(JavaCompile.class, javac -> JunitReportsFinalizer.registerFinalizer((Task)javac, timer, JavacFailuresSupplier.create(javac), (Provider<Directory>)reportsExtension.getReportsDirectory().map(dir -> dir.dir("javac"))));
        });
    }

    private static Provider<File> junitPath(DirectoryProperty basePath, String testPath) {
        return basePath.map(dir -> dir.dir("junit")).map(dir -> dir.file(String.join((CharSequence)File.separator, Splitter.on((char)':').splitToList((CharSequence)testPath.substring(1))))).map(RegularFile::getAsFile);
    }

    private static void configureBuildFailureFinalizer(Project rootProject, Provider<Directory> reportsDir) {
        Provider targetFileProvider = reportsDir.map(dir -> {
            int attemptNumber = 1;
            Path targetFile = dir.getAsFile().toPath().resolve("gradle").resolve("build.xml");
            while (targetFile.toFile().exists()) {
                targetFile = dir.getAsFile().toPath().resolve("gradle").resolve("build" + ++attemptNumber + ".xml");
            }
            return dir.file(targetFile.toAbsolutePath().toString());
        });
        BuildFailureListener listener = new BuildFailureListener();
        BuildFinishedAction action = new BuildFinishedAction((Provider<RegularFile>)targetFileProvider, listener);
        rootProject.getGradle().addListener((Object)listener);
        rootProject.getGradle().buildFinished((Action)action);
    }
}

