/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.junit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.palantir.gradle.junit.Failure;
import java.io.File;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;

abstract class Failure_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private String source;
    private File file;
    private int line;
    private String severity;
    private String message;
    private String details;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    Failure_Builder() {
    }

    public static Failure.Builder from(Failure value) {
        return new Failure.Builder().mergeFrom(value);
    }

    public Failure.Builder source(String source) {
        this.source = (String)Preconditions.checkNotNull((Object)source);
        return (Failure.Builder)this;
    }

    public Failure.Builder mapSource(UnaryOperator<String> mapper) {
        return this.source((String)mapper.apply(this.source()));
    }

    public String source() {
        return this.source;
    }

    public Failure.Builder file(File file) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this._unsetProperties.remove((Object)Property.FILE);
        return (Failure.Builder)this;
    }

    public Failure.Builder mapFile(UnaryOperator<File> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.file((File)mapper.apply(this.file()));
    }

    public File file() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.FILE) ? 1 : 0) != 0, (Object)"file not set");
        return this.file;
    }

    public Failure.Builder line(int line) {
        this.line = line;
        this._unsetProperties.remove((Object)Property.LINE);
        return (Failure.Builder)this;
    }

    public Failure.Builder mapLine(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.line((Integer)mapper.apply(this.line()));
    }

    public int line() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LINE) ? 1 : 0) != 0, (Object)"line not set");
        return this.line;
    }

    public Failure.Builder severity(String severity) {
        this.severity = (String)Preconditions.checkNotNull((Object)severity);
        this._unsetProperties.remove((Object)Property.SEVERITY);
        return (Failure.Builder)this;
    }

    public Failure.Builder mapSeverity(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.severity((String)mapper.apply(this.severity()));
    }

    public String severity() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SEVERITY) ? 1 : 0) != 0, (Object)"severity not set");
        return this.severity;
    }

    public Failure.Builder message(String message) {
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this._unsetProperties.remove((Object)Property.MESSAGE);
        return (Failure.Builder)this;
    }

    public Failure.Builder mapMessage(UnaryOperator<String> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.message((String)mapper.apply(this.message()));
    }

    public String message() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.MESSAGE) ? 1 : 0) != 0, (Object)"message not set");
        return this.message;
    }

    public Failure.Builder details(String details) {
        this.details = (String)Preconditions.checkNotNull((Object)details);
        return (Failure.Builder)this;
    }

    public Failure.Builder mapDetails(UnaryOperator<String> mapper) {
        return this.details((String)mapper.apply(this.details()));
    }

    public String details() {
        return this.details;
    }

    public Failure.Builder mergeFrom(Failure value) {
        Failure.Builder _defaults = new Failure.Builder();
        if (!Objects.equals(value.source(), ((Failure_Builder)_defaults).source())) {
            this.source(value.source());
        }
        if (_defaults._unsetProperties.contains((Object)Property.FILE) || !Objects.equals(value.file(), ((Failure_Builder)_defaults).file())) {
            this.file(value.file());
        }
        if (_defaults._unsetProperties.contains((Object)Property.LINE) || !Objects.equals(value.line(), ((Failure_Builder)_defaults).line())) {
            this.line(value.line());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SEVERITY) || !Objects.equals(value.severity(), ((Failure_Builder)_defaults).severity())) {
            this.severity(value.severity());
        }
        if (_defaults._unsetProperties.contains((Object)Property.MESSAGE) || !Objects.equals(value.message(), ((Failure_Builder)_defaults).message())) {
            this.message(value.message());
        }
        if (!Objects.equals(value.details(), ((Failure_Builder)_defaults).details())) {
            this.details(value.details());
        }
        return (Failure.Builder)this;
    }

    public Failure.Builder mergeFrom(Failure.Builder template) {
        Failure.Builder _defaults = new Failure.Builder();
        Failure.Builder base = template;
        if (!Objects.equals(template.source(), ((Failure_Builder)_defaults).source())) {
            this.source(template.source());
        }
        if (!(base._unsetProperties.contains((Object)Property.FILE) || !_defaults._unsetProperties.contains((Object)Property.FILE) && Objects.equals(template.file(), ((Failure_Builder)_defaults).file()))) {
            this.file(template.file());
        }
        if (!(base._unsetProperties.contains((Object)Property.LINE) || !_defaults._unsetProperties.contains((Object)Property.LINE) && Objects.equals(template.line(), ((Failure_Builder)_defaults).line()))) {
            this.line(template.line());
        }
        if (!(base._unsetProperties.contains((Object)Property.SEVERITY) || !_defaults._unsetProperties.contains((Object)Property.SEVERITY) && Objects.equals(template.severity(), ((Failure_Builder)_defaults).severity()))) {
            this.severity(template.severity());
        }
        if (!(base._unsetProperties.contains((Object)Property.MESSAGE) || !_defaults._unsetProperties.contains((Object)Property.MESSAGE) && Objects.equals(template.message(), ((Failure_Builder)_defaults).message()))) {
            this.message(template.message());
        }
        if (!Objects.equals(template.details(), ((Failure_Builder)_defaults).details())) {
            this.details(template.details());
        }
        return (Failure.Builder)this;
    }

    public Failure.Builder clear() {
        Failure.Builder _defaults = new Failure.Builder();
        this.source = _defaults.source;
        this.file = _defaults.file;
        this.line = _defaults.line;
        this.severity = _defaults.severity;
        this.message = _defaults.message;
        this.details = _defaults.details;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (Failure.Builder)this;
    }

    public Failure build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public Failure buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements Failure {
        private final String source;
        private final File file;
        private final int line;
        private final String severity;
        private final String message;
        private final String details;
        private final EnumSet<Property> _unsetProperties;

        Partial(Failure_Builder builder) {
            this.source = builder.source;
            this.file = builder.file;
            this.line = builder.line;
            this.severity = builder.severity;
            this.message = builder.message;
            this.details = builder.details;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public File file() {
            if (this._unsetProperties.contains((Object)Property.FILE)) {
                throw new UnsupportedOperationException("file not set");
            }
            return this.file;
        }

        @Override
        public int line() {
            if (this._unsetProperties.contains((Object)Property.LINE)) {
                throw new UnsupportedOperationException("line not set");
            }
            return this.line;
        }

        @Override
        public String severity() {
            if (this._unsetProperties.contains((Object)Property.SEVERITY)) {
                throw new UnsupportedOperationException("severity not set");
            }
            return this.severity;
        }

        @Override
        public String message() {
            if (this._unsetProperties.contains((Object)Property.MESSAGE)) {
                throw new UnsupportedOperationException("message not set");
            }
            return this.message;
        }

        @Override
        public String details() {
            return this.details;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.source, other.source) && Objects.equals(this.file, other.file) && Objects.equals(this.line, other.line) && Objects.equals(this.severity, other.severity) && Objects.equals(this.message, other.message) && Objects.equals(this.details, other.details) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.file, this.line, this.severity, this.message, this.details, this._unsetProperties);
        }

        public String toString() {
            return "partial Failure{" + COMMA_JOINER.join((Object)("source=" + this.source), (Object)(!this._unsetProperties.contains((Object)Property.FILE) ? "file=" + this.file : null), new Object[]{!this._unsetProperties.contains((Object)Property.LINE) ? "line=" + this.line : null, !this._unsetProperties.contains((Object)Property.SEVERITY) ? "severity=" + this.severity : null, !this._unsetProperties.contains((Object)Property.MESSAGE) ? "message=" + this.message : null, "details=" + this.details}) + "}";
        }
    }

    private static final class Value
    implements Failure {
        private final String source;
        private final File file;
        private final int line;
        private final String severity;
        private final String message;
        private final String details;

        private Value(Failure_Builder builder) {
            this.source = builder.source;
            this.file = builder.file;
            this.line = builder.line;
            this.severity = builder.severity;
            this.message = builder.message;
            this.details = builder.details;
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public File file() {
            return this.file;
        }

        @Override
        public int line() {
            return this.line;
        }

        @Override
        public String severity() {
            return this.severity;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public String details() {
            return this.details;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.source, other.source) && Objects.equals(this.file, other.file) && Objects.equals(this.line, other.line) && Objects.equals(this.severity, other.severity) && Objects.equals(this.message, other.message) && Objects.equals(this.details, other.details);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.file, this.line, this.severity, this.message, this.details);
        }

        public String toString() {
            return "Failure{source=" + this.source + ", file=" + this.file + ", line=" + this.line + ", severity=" + this.severity + ", message=" + this.message + ", details=" + this.details + "}";
        }
    }

    private static enum Property {
        FILE("file"),
        LINE("line"),
        SEVERITY("severity"),
        MESSAGE("message");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

