/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.base.Preconditions;
import com.palantir.baseline.plugins.BaselineTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;

public class CheckJUnitDependencies
extends DefaultTask {
    public CheckJUnitDependencies() {
        this.setGroup("Verification");
        this.setDescription("Ensures the correct JUnit4/5 dependencies are present, otherwise tests may silently not run");
        this.getOutputs().upToDateWhen(_task -> true);
    }

    @TaskAction
    public final void validateDependencies() {
        this.getProbablyTestSourceSets().forEach(ss -> {
            Optional<Test> maybeTestTask = BaselineTesting.getTestTaskForSourceSet(this.getProject(), ss);
            if (!maybeTestTask.isPresent()) {
                return;
            }
            Test task = maybeTestTask.get();
            this.getProject().getLogger().info("Analyzing source set {} with task {}", (Object)ss.getName(), (Object)task.getName());
            this.validateSourceSet((SourceSet)ss, task);
        });
    }

    @Classpath
    public final Provider<List<Configuration>> getConfigurations() {
        return this.getProject().provider(() -> this.getProbablyTestSourceSets().map(SourceSet::getRuntimeClasspathConfigurationName).map(arg_0 -> ((ConfigurationContainer)this.getProject().getConfigurations()).getByName(arg_0)).collect(Collectors.toList()));
    }

    private Stream<SourceSet> getProbablyTestSourceSets() {
        return ((JavaPluginConvention)this.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().stream().filter(ss -> !ss.getName().equals("main"));
    }

    private void validateSourceSet(SourceSet ss, Test task) {
        Set deps = this.getProject().getConfigurations().getByName(ss.getRuntimeClasspathConfigurationName()).getIncoming().getResolutionResult().getAllComponents();
        boolean junitJupiterIsPresent = this.hasDep(deps, CheckJUnitDependencies::isJunitJupiter);
        boolean vintageEngineExists = this.hasDep(deps, CheckJUnitDependencies::isVintageEngine);
        boolean spockDependency = this.hasDep(deps, CheckJUnitDependencies::isSpock);
        String testRuntimeOnly = ss.getRuntimeOnlyConfigurationName();
        boolean junitPlatformEnabled = BaselineTesting.useJUnitPlatformEnabled(task);
        if (this.sourceSetMentionsJUnit5Api(ss)) {
            String implementation = ss.getImplementationConfigurationName();
            Preconditions.checkState((boolean)junitPlatformEnabled, (Object)("Some tests mention JUnit5, but the '" + task.getName() + "' task does not have useJUnitPlatform() enabled. This means tests may be silently not running! Please add the following:\n\n    " + implementation + " 'org.junit.jupiter:junit-jupiter'\n"));
        }
        if (this.sourceSetMentionsJUnit4(ss)) {
            if (junitPlatformEnabled) {
                Preconditions.checkState((boolean)junitJupiterIsPresent, (Object)("Tests may be silently not running! Some tests still use JUnit4, but Gradle has been set to use JUnit Platform. To ensure your old JUnit4 tests still run, please add the following:\n\n    " + testRuntimeOnly + " 'org.junit.jupiter:junit-jupiter'\n\nOtherwise they will silently not run."));
                Preconditions.checkState((boolean)vintageEngineExists, (Object)("Tests may be silently not running! Some tests still use JUnit4, but Gradle has been set to use JUnit Platform. To ensure your old JUnit4 tests still run, please add the following:\n\n    " + testRuntimeOnly + " 'org.junit.vintage:junit-vintage-engine'\n\nOtherwise they will silently not run."));
            } else {
                Preconditions.checkState((!junitJupiterIsPresent ? 1 : 0) != 0, (Object)"Tests may be silently not running! Please remove 'org.junit.jupiter:junit-jupiter' dependency because tests use JUnit4 and useJUnitPlatform() is not enabled.");
            }
        }
        if (spockDependency && junitPlatformEnabled) {
            Preconditions.checkState((boolean)vintageEngineExists, (Object)("Tests may be silently not running! Spock dependency detected (which uses a JUnit4 Runner under the hood). Please add the following:\n\n    " + testRuntimeOnly + " 'org.junit.vintage:junit-vintage-engine'\n\n"));
        }
    }

    private boolean hasDep(Set<ResolvedComponentResult> deps, Predicate<ModuleVersionIdentifier> spec) {
        return deps.stream().anyMatch(component -> spec.test(component.getModuleVersion()));
    }

    private boolean sourceSetMentionsJUnit4(SourceSet ss) {
        return !ss.getAllJava().filter(file -> this.fileContainsSubstring((File)file, l -> l.contains("org.junit.Test") || l.contains("org.junit.runner") || l.contains("org.junit.ClassRule"))).isEmpty();
    }

    private boolean sourceSetMentionsJUnit5Api(SourceSet ss) {
        return !ss.getAllJava().filter(file -> this.fileContainsSubstring((File)file, l -> l.contains("org.junit.jupiter.api."))).isEmpty();
    }

    private boolean fileContainsSubstring(File file, Predicate<String> substring) {
        boolean bl;
        block8: {
            Stream<String> lines = Files.lines(file.toPath());
            try {
                boolean hit = lines.anyMatch(substring::test);
                this.getProject().getLogger().debug("[{}] {}", (Object)(hit ? "hit" : "miss"), (Object)file);
                bl = hit;
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to check file " + file, e);
                }
            }
            lines.close();
        }
        return bl;
    }

    private static boolean isJunitJupiter(ModuleVersionIdentifier dep) {
        return "org.junit.jupiter".equals(dep.getGroup()) && "junit-jupiter".equals(dep.getName());
    }

    private static boolean isVintageEngine(ModuleVersionIdentifier dep) {
        return "org.junit.vintage".equals(dep.getGroup()) && "junit-vintage-engine".equals(dep.getName());
    }

    private static boolean isSpock(ModuleVersionIdentifier dep) {
        return "org.spockframework".equals(dep.getGroup()) && "spock-core".equals(dep.getName());
    }
}

