/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.palantir.baseline.tasks.ClassUniquenessAnalyzer;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GFileUtils;
import org.slf4j.Logger;

@CacheableTask
public class CheckClassUniquenessLockTask
extends DefaultTask {
    private static final String HEADER = "# Danger! Multiple jars contain identically named classes. This may cause different behaviour depending on classpath ordering.\n# Run ./gradlew checkClassUniqueness --write-locks to update this file\n\n";
    public final SetProperty<Configuration> configurations = this.getProject().getObjects().setProperty(Configuration.class);
    private final File lockFile = this.getProject().file((Object)"baseline-class-uniqueness.lock");

    public CheckClassUniquenessLockTask() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !((Set)CheckClassUniquenessLockTask.this.configurations.get()).isEmpty();
            }
        });
    }

    @Input
    public final Map<String, ImmutableList<String>> getContentsOfAllConfigurations() {
        return ((Set)this.configurations.get()).stream().collect(Collectors.toMap(Configuration::getName, configuration -> (ImmutableList)configuration.getIncoming().getResolutionResult().getAllComponents().stream().map(resolvedComponentResult -> Objects.toString(resolvedComponentResult.getModuleVersion())).collect(ImmutableList.toImmutableList())));
    }

    @OutputFile
    public final File getLockFile() {
        return this.lockFile;
    }

    @TaskAction
    public final void doIt() {
        ImmutableSortedMap resultsByConfiguration = (ImmutableSortedMap)((Set)this.configurations.get()).stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Configuration::getName, configuration -> {
            ClassUniquenessAnalyzer analyzer = new ClassUniquenessAnalyzer((Logger)this.getProject().getLogger());
            analyzer.analyzeConfiguration((Configuration)configuration);
            Collection<Set<ModuleVersionIdentifier>> problemJars = analyzer.getDifferingProblemJars();
            if (problemJars.isEmpty()) {
                return Optional.empty();
            }
            ImmutableSortedMap clashingHeadersToClasses = (ImmutableSortedMap)problemJars.stream().collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), this::clashingJarHeader, clashingJars -> this.clashingClasses(analyzer, (Set<ModuleVersionIdentifier>)clashingJars)));
            return Optional.of(clashingHeadersToClasses.entrySet().stream().flatMap(entry -> {
                String clashingJarHeader = (String)entry.getKey();
                String clashingClasses = (String)entry.getValue();
                return Stream.of(clashingJarHeader, clashingClasses);
            }).collect(Collectors.joining("\n")));
        }));
        boolean conflictsFound = resultsByConfiguration.values().stream().anyMatch(Optional::isPresent);
        if (!conflictsFound) {
            this.ensureLockfileDoesNotExist();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(HEADER);
            resultsByConfiguration.forEach((configuration, maybeContents) -> maybeContents.ifPresent(contents -> {
                stringBuilder.append("## ").append((String)configuration).append("\n");
                stringBuilder.append((String)contents);
            }));
            stringBuilder.append('\n');
            this.ensureLockfileContains(stringBuilder.toString());
        }
    }

    private String clashingClasses(ClassUniquenessAnalyzer analyzer, Set<ModuleVersionIdentifier> clashingJars) {
        return analyzer.getDifferingSharedClassesInProblemJars(clashingJars).stream().sorted().map(className -> String.format("  - %s", className)).collect(Collectors.joining("\n"));
    }

    private String clashingJarHeader(Set<ModuleVersionIdentifier> clashingJars) {
        return clashingJars.stream().map(mvi -> mvi.getGroup() + ":" + mvi.getName()).sorted().collect(Collectors.joining(", ", "[", "]"));
    }

    private void ensureLockfileContains(String expected) {
        if (this.getProject().getGradle().getStartParameter().isWriteDependencyLocks()) {
            GFileUtils.writeFile((String)expected, (File)this.lockFile);
            this.getLogger().lifecycle("Updated {}", new Object[]{this.getProject().getRootDir().toPath().relativize(this.lockFile.toPath())});
            return;
        }
        if (!this.lockFile.exists()) {
            throw new GradleException("baseline-class-uniqueness detected multiple jars containing identically named classes. Please resolve these problems, or run `./gradlew checkClassUniqueness --write-locks` to accept them:\n\n" + expected);
        }
        String onDisk = GFileUtils.readFile((File)this.lockFile);
        if (!onDisk.equals(expected)) {
            List onDiskLines = Splitter.on((char)'\n').splitToList((CharSequence)onDisk);
            Patch diff = DiffUtils.diff((List)onDiskLines, (List)Splitter.on((char)'\n').splitToList((CharSequence)expected));
            throw new GradleException(String.join((CharSequence)"\n", String.format("%s is out of date, please run `./gradlew checkClassUniqueness --write-locks` to update this file. The diff is:", this.lockFile), "", String.join((CharSequence)"\n", DiffUtils.generateUnifiedDiff((String)"on disk", (String)"expected", (List)onDiskLines, (Patch)diff, (int)Integer.MAX_VALUE)), "", "On disk was:", "", onDisk, "", "Expected was:", expected));
        }
    }

    private void ensureLockfileDoesNotExist() {
        if (this.lockFile.exists()) {
            if (this.getProject().getGradle().getStartParameter().isWriteDependencyLocks()) {
                GFileUtils.deleteQuietly((File)this.lockFile);
                this.getLogger().lifecycle("Deleted {}", new Object[]{this.getProject().getRootDir().toPath().relativize(this.lockFile.toPath())});
            } else {
                throw new GradleException(this.lockFile + " should not exist (as no problems were found).");
            }
        }
    }
}

