/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import java.util.Collections;
import java.util.List;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.process.CommandLineArgumentProvider;

public final class BaselineEnablePreviewFlag
implements Plugin<Project> {
    private static final String FLAG = "--enable-preview";

    public void apply(Project project) {
        Provider enablePreview = project.provider(() -> {
            JavaVersion jvmExecutingGradle = JavaVersion.current();
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaConvention == null) {
                return false;
            }
            return javaConvention.getSourceCompatibility() == jvmExecutingGradle;
        });
        project.getExtensions().getExtraProperties().set("enablePreview", (Object)enablePreview);
        project.getPlugins().withId("java", _unused -> {
            project.getTasks().withType(JavaCompile.class, t -> {
                List args = t.getOptions().getCompilerArgumentProviders();
                args.add(new MaybeEnablePreview((Provider<Boolean>)enablePreview));
            });
            project.getTasks().withType(Test.class, t -> t.getJvmArgumentProviders().add(new MaybeEnablePreview((Provider<Boolean>)enablePreview)));
            project.getTasks().withType(JavaExec.class, t -> t.getJvmArgumentProviders().add(new MaybeEnablePreview((Provider<Boolean>)enablePreview)));
            project.afterEvaluate(_unused2 -> {
                if (((Boolean)enablePreview.get()).booleanValue()) {
                    JavaVersion sourceCompat = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceCompatibility();
                    project.getTasks().withType(Javadoc.class, t -> {
                        CoreJavadocOptions options = (CoreJavadocOptions)t.getOptions();
                        options.addBooleanOption("-enable-preview", true);
                        options.addStringOption("source", sourceCompat.getMajorVersion());
                    });
                }
            });
        });
    }

    private static class MaybeEnablePreview
    implements CommandLineArgumentProvider {
        private final Provider<Boolean> shouldEnable;

        MaybeEnablePreview(Provider<Boolean> shouldEnable) {
            this.shouldEnable = shouldEnable;
        }

        public Iterable<String> asArguments() {
            return (Boolean)this.shouldEnable.get() != false ? Collections.singletonList(BaselineEnablePreviewFlag.FLAG) : Collections.emptyList();
        }
    }
}

