/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class CompileRefasterTask
extends JavaCompile {
    private final Property<Configuration> refasterSources = this.getProject().getObjects().property(Configuration.class);
    private final Property<File> refasterRulesFile = this.getProject().getObjects().property(File.class);

    public CompileRefasterTask() {
        this.setDestinationDir(this.getTemporaryDir());
        this.getOptions().setIncremental(true);
    }

    protected final void compile(IncrementalTaskInputs inputs) {
        this.getOptions().getCompilerArgumentProviders().clear();
        this.getOptions().setCompilerArgs((List)ImmutableList.of((Object)("-Xplugin:BaselineRefasterCompiler --out " + ((File)this.refasterRulesFile.get()).getAbsolutePath())));
        List javaSources = ((Configuration)this.getRefasterSources().get()).getResolvedConfiguration().getFirstLevelModuleDependencies().stream().flatMap(dep -> dep.getModuleArtifacts().stream()).map(ResolvedArtifact::getFile).flatMap(file -> {
            if (file.getName().endsWith(".jar")) {
                return this.getProject().zipTree(file).getFiles().stream().filter(zipFile -> zipFile.getName().endsWith(".java"));
            }
            if (file.getName().endsWith(".java")) {
                return Stream.of(file);
            }
            this.getLogger().warn("Skipping refaster rule: {}", file);
            return Stream.empty();
        }).collect(Collectors.toList());
        if (!javaSources.isEmpty()) {
            this.setSource(javaSources);
            super.compile(inputs);
        } else {
            this.setDidWork(false);
        }
    }

    @InputFiles
    public final Property<Configuration> getRefasterSources() {
        return this.refasterSources;
    }

    @OutputFile
    public final Property<File> getRefasterRulesFile() {
        return this.refasterRulesFile;
    }
}

