/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.tasks;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.slf4j.Logger;

public final class ClassUniquenessAnalyzer {
    private final Map<Set<ModuleVersionIdentifier>, Set<String>> jarsToClasses = new HashMap<Set<ModuleVersionIdentifier>, Set<String>>();
    private final Map<String, Set<HashCode>> classToHashCodes = new HashMap<String, Set<HashCode>>();
    private final Logger log;

    public ClassUniquenessAnalyzer(Logger log) {
        this.log = log;
    }

    public void analyzeConfiguration(Configuration configuration) {
        Instant before = Instant.now();
        Set dependencies = configuration.getResolvedConfiguration().getResolvedArtifacts();
        HashMap classToJars = new HashMap();
        HashMap tempClassToHashCodes = new HashMap();
        dependencies.stream().forEach(resolvedArtifact -> {
            File file = resolvedArtifact.getFile();
            if (!file.exists()) {
                this.log.info("Skipping non-existent jar {}: {}", resolvedArtifact, (Object)file);
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 JarInputStream jarInputStream = new JarInputStream(fileInputStream);){
                JarEntry entry;
                while ((entry = jarInputStream.getNextJarEntry()) != null) {
                    if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().contains("module-info.class")) continue;
                    String className = entry.getName().replaceAll("/", ".").replaceAll(".class", "");
                    HashingInputStream inputStream = new HashingInputStream(Hashing.sha256(), (InputStream)jarInputStream);
                    ByteStreams.exhaust((InputStream)inputStream);
                    ClassUniquenessAnalyzer.multiMapPut(classToJars, className, resolvedArtifact.getModuleVersion().getId());
                    ClassUniquenessAnalyzer.multiMapPut(tempClassToHashCodes, className, inputStream.hash());
                }
            }
            catch (IOException e) {
                this.log.error("Failed to read JarFile {}", resolvedArtifact, (Object)e);
                throw new RuntimeException(e);
            }
        });
        classToJars.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> ClassUniquenessAnalyzer.multiMapPut(this.jarsToClasses, (Set)entry.getValue(), (String)entry.getKey()));
        tempClassToHashCodes.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> ((Set)entry.getValue()).forEach(value -> ClassUniquenessAnalyzer.multiMapPut(this.classToHashCodes, (String)entry.getKey(), value)));
        Instant after = Instant.now();
        this.log.info("Checked {} classes from {} dependencies for uniqueness ({}ms)", new Object[]{classToJars.size(), dependencies.size(), Duration.between(before, after).toMillis()});
    }

    private Collection<Set<ModuleVersionIdentifier>> getProblemJars() {
        return this.jarsToClasses.keySet();
    }

    public Set<String> getSharedClassesInProblemJars(Collection<ModuleVersionIdentifier> problemJars) {
        return this.jarsToClasses.get(problemJars);
    }

    public Collection<Set<ModuleVersionIdentifier>> getDifferingProblemJars() {
        return this.getProblemJars().stream().filter(jars -> this.getDifferingSharedClassesInProblemJars((Collection<ModuleVersionIdentifier>)jars).size() > 0).collect(Collectors.toSet());
    }

    public Set<String> getDifferingSharedClassesInProblemJars(Collection<ModuleVersionIdentifier> problemJars) {
        return this.getSharedClassesInProblemJars(problemJars).stream().filter(this.classToHashCodes::containsKey).collect(Collectors.toSet());
    }

    private static <K, V> void multiMapPut(Map<K, Set<V>> map, K key, V value) {
        map.compute(key, (unused, collection) -> {
            Set newCollection = collection != null ? collection : new HashSet();
            newCollection.add(value);
            return newCollection;
        });
    }
}

