/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public final class BaselineFixGradleJava
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().withPlugin("java-base", javaPlugin -> {
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            sourceSets.configureEach(sourceSet -> this.fixLegacyJavaConfigurationsForSourceSet(project.getConfigurations(), (SourceSet)sourceSet));
        });
    }

    private void fixLegacyJavaConfigurationsForSourceSet(ConfigurationContainer configurations, SourceSet sourceSet) {
        Stream.of(sourceSet.getCompileOnlyConfigurationName(), sourceSet.getCompileConfigurationName(), sourceSet.getRuntimeConfigurationName()).forEach(confName -> configurations.named(confName, conf -> {
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(false);
        }));
    }
}

