/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.base.CaseFormat;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import java.util.Locale;
import java.util.Optional;

@BugPattern(name="Slf4jLevelCheck", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Slf4j log.is[Level]Enabled level must match the most severe log statement")
@AutoService(value={BugChecker.class})
public final class Slf4jLevelCheck
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> LEVEL_CHECK_METHOD = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled"});
    private static final Matcher<ExpressionTree> LOG_METHOD = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"trace", "debug", "info", "warn", "error"});

    public Description matchIf(IfTree tree, VisitorState state) {
        if (tree.getElseStatement() != null) {
            return Description.NO_MATCH;
        }
        Optional<MethodInvocationTree> maybeCheckLevel = tree.getCondition().accept(ConditionVisitor.INSTANCE, state);
        if (!maybeCheckLevel.isPresent()) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree levelCheckInvocation = maybeCheckLevel.get();
        LogLevel checkLevel = Slf4jLevelCheck.levelCheckLogLevel(levelCheckInvocation, state);
        LogLevel mostSevere = tree.getThenStatement().accept(MostSevereLogStatementScanner.INSTANCE, state);
        if (mostSevere == null) {
            return Description.NO_MATCH;
        }
        if (mostSevere == checkLevel) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)levelCheckInvocation, (String)mostSevere.levelCheckMethodName(), (VisitorState)state)).build();
    }

    private static LogLevel levelCheckLogLevel(MethodInvocationTree tree, VisitorState state) {
        for (LogLevel level : LogLevel.values()) {
            if (!level.matchesLevelCheck(tree, state)) continue;
            return level;
        }
        throw new IllegalStateException("Expected a level check, but was: " + state.getSourceForNode((Tree)tree));
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

        private final String levelCheckMethodName = "is" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name()) + "Enabled";
        private final Matcher<ExpressionTree> levelCheckMatcher = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").named(this.levelCheckMethodName);
        private final Matcher<ExpressionTree> logMatcher = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").named(this.name().toLowerCase(Locale.ENGLISH));

        boolean matchesLevelCheck(ExpressionTree tree, VisitorState state) {
            return this.levelCheckMatcher.matches((Tree)tree, state);
        }

        boolean matchesLogStatement(ExpressionTree tree, VisitorState state) {
            return this.logMatcher.matches((Tree)tree, state);
        }

        String levelCheckMethodName() {
            return this.levelCheckMethodName;
        }
    }

    private static final class MostSevereLogStatementScanner
    extends TreeScanner<LogLevel, VisitorState> {
        private static final MostSevereLogStatementScanner INSTANCE = new MostSevereLogStatementScanner();

        private MostSevereLogStatementScanner() {
        }

        @Override
        public LogLevel visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            if (LOG_METHOD.matches((Tree)node, state)) {
                for (LogLevel level : LogLevel.values()) {
                    if (!level.matchesLogStatement(node, state)) continue;
                    return level;
                }
            }
            return null;
        }

        @Override
        public LogLevel visitCatch(CatchTree node, VisitorState state) {
            return null;
        }

        @Override
        public LogLevel reduce(LogLevel r1, LogLevel r2) {
            if (r1 == null) {
                return r2;
            }
            if (r2 == null) {
                return r1;
            }
            return r1.ordinal() > r2.ordinal() ? r1 : r2;
        }
    }

    private static final class ConditionVisitor
    extends SimpleTreeVisitor<Optional<MethodInvocationTree>, VisitorState> {
        private static final ConditionVisitor INSTANCE = new ConditionVisitor();

        private ConditionVisitor() {
            super(Optional.empty());
        }

        @Override
        public Optional<MethodInvocationTree> visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            if (LEVEL_CHECK_METHOD.matches((Tree)node, state)) {
                return Optional.of(node);
            }
            return Optional.empty();
        }

        @Override
        public Optional<MethodInvocationTree> visitParenthesized(ParenthesizedTree node, VisitorState state) {
            return node.getExpression().accept(this, state);
        }

        @Override
        public Optional<MethodInvocationTree> visitBinary(BinaryTree node, VisitorState state) {
            if (node.getKind() != Tree.Kind.CONDITIONAL_AND) {
                return Optional.empty();
            }
            Optional<MethodInvocationTree> lhs = node.getLeftOperand().accept(this, state);
            Optional<MethodInvocationTree> rhs = node.getRightOperand().accept(this, state);
            if (lhs.isPresent() && rhs.isPresent()) {
                return Optional.empty();
            }
            return lhs.isPresent() ? lhs : rhs;
        }
    }
}

