/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

abstract class PreconditionsMessageFormat
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final Matcher<ExpressionTree> methodMatcher;

    protected PreconditionsMessageFormat(Matcher<ExpressionTree> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    protected abstract Description matchMessageFormat(MethodInvocationTree var1, String var2, VisitorState var3);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!this.methodMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        if (args.size() <= 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree messageArg = args.get(1);
        if (!messageArg.getKind().equals((Object)Tree.Kind.STRING_LITERAL)) {
            return Description.NO_MATCH;
        }
        if (!(messageArg instanceof LiteralTree)) {
            return Description.NO_MATCH;
        }
        LiteralTree literalTreeMessageArg = (LiteralTree)messageArg;
        Object value = literalTreeMessageArg.getValue();
        if (!(value instanceof String)) {
            return Description.NO_MATCH;
        }
        String message = (String)value;
        return this.matchMessageFormat(tree, message, state);
    }
}

