/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.PreconditionsMessageFormat;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.regex.Pattern;

@BugPattern(name="LogSafePreconditionsMessageFormat", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="logsafe Preconditions.checkX() methods should not have print-f or slf4j style formatting.")
@AutoService(value={BugChecker.class})
public final class LogSafePreconditionsMessageFormat
extends PreconditionsMessageFormat {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> LOGSAFE_PRECONDITIONS_METHOD = MethodMatchers.staticMethod().onClassAny(new String[]{"com.palantir.logsafe.Preconditions"}).withNameMatching(Pattern.compile("checkArgument|checkState|checkNotNull"));

    public LogSafePreconditionsMessageFormat() {
        super(LOGSAFE_PRECONDITIONS_METHOD);
    }

    @Override
    protected Description matchMessageFormat(MethodInvocationTree tree, String message, VisitorState state) {
        if (message.contains("%s")) {
            return this.buildDescription(tree).setMessage("Do not use printf-style formatting in logsafe Preconditions. Logsafe exceptions provide a simple message and key-value pairs of arguments, no interpolation is performed.").build();
        }
        if (message.contains("{}")) {
            return this.buildDescription(tree).setMessage("Do not use slf4j-style formatting in logsafe Preconditions. Logsafe exceptions provide a simple message and key-value pairs of arguments, no interpolation is performed.").build();
        }
        return Description.NO_MATCH;
    }
}

