/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="ConsistentLoggerName", link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Loggers created using getLogger(Class<?>) must be named 'log'.")
@AutoService(value={BugChecker.class})
public final class ConsistentLoggerName
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<VariableTree> matcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), Matchers.isStatic(), Matchers.hasModifier((Modifier)Modifier.FINAL), Matchers.hasModifier((Modifier)Modifier.PRIVATE), Matchers.isSubtypeOf((String)"org.slf4j.Logger"), Matchers.variableInitializer((Matcher)MethodMatchers.staticMethod().onClass("org.slf4j.LoggerFactory").named("getLogger").withParameters(new String[]{Class.class.getName()}))});

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (matcher.matches((Tree)tree, state) && !tree.getName().contentEquals("log")) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameVariable((VariableTree)tree, (String)"log", (VisitorState)state)).build();
        }
        return Description.NO_MATCH;
    }
}

