/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="StrictUnusedVariable", altNames={"unused", "UnusedVariable"}, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, summary="Unused.", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.ERROR, documentSuppression=false)
public final class StrictUnusedVariable
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<String> EXEMPT_PREFIXES = ImmutableSet.of((Object)"_");
    private static final ImmutableSet<String> EXEMPTING_VARIABLE_ANNOTATIONS = ImmutableSet.of((Object)"javax.persistence.Basic", (Object)"javax.persistence.Column", (Object)"javax.persistence.Id", (Object)"javax.persistence.Version", (Object)"javax.xml.bind.annotation.XmlElement", (Object)"org.junit.Rule", (Object[])new String[]{"org.mockito.Mock", "org.openqa.selenium.support.FindBy", "org.openqa.selenium.support.FindBys"});
    private static final ImmutableSet<String> EXEMPTING_SUPER_TYPES = ImmutableSet.of();
    private static final ImmutableSet<String> EXEMPTING_FIELD_SUPER_TYPES = ImmutableSet.of((Object)"org.junit.rules.TestRule", (Object)"org.slf4j.Logger");
    private static final ImmutableList<String> SPECIAL_FIELDS = ImmutableList.of((Object)"serialVersionUID", (Object)"TAG");
    private static final String UNUSED = "unused";
    private static final ImmutableSet<Tree.Kind> TOP_LEVEL_EXPRESSIONS = ImmutableSet.of((Object)((Object)Tree.Kind.ASSIGNMENT), (Object)((Object)Tree.Kind.PREFIX_INCREMENT), (Object)((Object)Tree.Kind.PREFIX_DECREMENT), (Object)((Object)Tree.Kind.POSTFIX_INCREMENT), (Object)((Object)Tree.Kind.POSTFIX_DECREMENT), (Object)((Object)Tree.Kind.METHOD_INVOCATION), (Object[])new Tree.Kind[]{Tree.Kind.NEW_CLASS});

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (StrictUnusedVariable.hasNativeMethods(tree)) {
            return Description.NO_MATCH;
        }
        VariableFinder variableFinder = new VariableFinder(state);
        variableFinder.scan(state.getPath(), null);
        this.checkUsedVariables(state, variableFinder);
        Map unusedElements = variableFinder.unusedElements;
        Set onlyCheckForReassignments = variableFinder.onlyCheckForReassignments;
        ListMultimap usageSites = variableFinder.usageSites;
        FilterUsedVariables filterUsedVariables = new FilterUsedVariables(unusedElements, usageSites);
        filterUsedVariables.scan(state.getPath(), null);
        Set isEverUsed = filterUsedVariables.isEverUsed;
        List unusedSpecs = filterUsedVariables.unusedSpecs;
        for (Map.Entry entry : unusedElements.entrySet()) {
            unusedSpecs.add(UnusedSpec.of((Symbol)entry.getKey(), (TreePath)entry.getValue(), usageSites.get((Object)((Symbol)entry.getKey())), null));
        }
        ImmutableListMultimap unusedSpecsBySymbol = Multimaps.index((Iterable)unusedSpecs, UnusedSpec::symbol);
        for (Map.Entry entry : unusedSpecsBySymbol.asMap().entrySet()) {
            ImmutableList<SuggestedFix> fixes;
            Symbol unusedSymbol = (Symbol)entry.getKey();
            Collection specs = (Collection)entry.getValue();
            ImmutableList allUsageSites = (ImmutableList)specs.stream().flatMap(u -> u.usageSites().stream()).collect(ImmutableList.toImmutableList());
            if (!unusedElements.containsKey(unusedSymbol)) {
                isEverUsed.add(unusedSymbol);
            }
            SuggestedFix makeFirstAssignmentDeclaration = StrictUnusedVariable.makeAssignmentDeclaration(unusedSymbol, specs, (ImmutableList<TreePath>)allUsageSites, state);
            if (onlyCheckForReassignments.contains(unusedSymbol) && specs.size() <= 1) continue;
            Tree unused = ((UnusedSpec)specs.iterator().next()).variableTree().getLeaf();
            Symbol.VarSymbol symbol = (Symbol.VarSymbol)unusedSymbol;
            if (symbol.getKind() == ElementKind.PARAMETER && !isEverUsed.contains(unusedSymbol)) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol.owner;
                int index = methodSymbol.params.indexOf(symbol);
                fixes = index == -1 ? StrictUnusedVariable.buildUnusedLambdaParameterFix(symbol, (Collection)entry.getValue(), state) : StrictUnusedVariable.buildUnusedParameterFixes(symbol, methodSymbol, (List<TreePath>)allUsageSites, state);
            } else {
                fixes = StrictUnusedVariable.buildUnusedVarFixes(symbol, (List<TreePath>)allUsageSites, state);
            }
            state.reportMatch(this.buildDescription(unused).setMessage(String.format("%s %s '%s' is never read.", unused instanceof VariableTree ? "The" : "The assignment to this", StrictUnusedVariable.describeVariable(symbol), symbol.name)).addAllFixes((List)fixes.stream().map(f -> SuggestedFix.builder().merge(makeFirstAssignmentDeclaration).merge(f).build()).collect(ImmutableList.toImmutableList())).build());
        }
        return Description.NO_MATCH;
    }

    private void checkUsedVariables(VisitorState state, VariableFinder variableFinder) {
        VariableUsage variableUsage = new VariableUsage();
        variableUsage.scan(state.getPath(), null);
        variableFinder.exemptedVariables.forEach((key, value) -> {
            List usageSites = variableUsage.usageSites.get(key);
            if (usageSites.size() <= 1) {
                return;
            }
            state.reportMatch(this.buildDescription((Tree)value).setMessage(String.format("The %s '%s' is read but has 'StrictUnusedVariable' suppressed because of its name.", StrictUnusedVariable.describeVariable((Symbol.VarSymbol)key), key.name)).addFix((Fix)StrictUnusedVariable.constructUsedVariableSuggestedFix(usageSites, state)).build());
        });
    }

    private static SuggestedFix constructUsedVariableSuggestedFix(List<TreePath> usagePaths, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (TreePath usagePath : usagePaths) {
            if (usagePath.getLeaf() instanceof VariableTree) {
                VariableTree variableTree = (VariableTree)usagePath.getLeaf();
                String variableName = variableTree.getName().toString();
                if (state.getEndPosition(variableTree.getType()) == -1) {
                    StrictUnusedVariable.renameVariable(variableTree, variableName, fix);
                    continue;
                }
                int startPos = state.getEndPosition(variableTree.getType()) + 1;
                int endPos = state.getEndPosition((Tree)variableTree);
                if (variableTree.getInitializer() != null) {
                    endPos = startPos + variableName.length();
                }
                if (startPos == -1 || endPos == -1) continue;
                StrictUnusedVariable.renameVariable(startPos, endPos, variableName, fix);
                continue;
            }
            if (!(usagePath.getLeaf() instanceof IdentifierTree)) continue;
            JCTree.JCIdent identifierTree = (JCTree.JCIdent)usagePath.getLeaf();
            int startPos = identifierTree.getStartPosition();
            int endPos = state.getEndPosition((Tree)identifierTree);
            if (startPos == -1 || endPos == -1) continue;
            StrictUnusedVariable.renameVariable(startPos, endPos, identifierTree.getName().toString(), fix);
        }
        return fix.build();
    }

    private static Optional<String> stripUnusedPrefix(String variableName) {
        return EXEMPT_PREFIXES.stream().filter(variableName::startsWith).findFirst().map(prefix -> prefix.length() == variableName.length() ? "value" : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, variableName.substring(prefix.length())));
    }

    private static void renameVariable(int startPos, int endPos, String name, SuggestedFix.Builder fix) {
        StrictUnusedVariable.stripUnusedPrefix(name).ifPresent(newName -> fix.replace(startPos, endPos, newName));
    }

    private static void renameVariable(Tree node, String name, SuggestedFix.Builder fix) {
        StrictUnusedVariable.stripUnusedPrefix(name).ifPresent(newName -> fix.replace(node, newName));
    }

    private static SuggestedFix makeAssignmentDeclaration(Symbol unusedSymbol, Collection<UnusedSpec> specs, ImmutableList<TreePath> allUsageSites, VisitorState state) {
        if (unusedSymbol.getKind() != ElementKind.LOCAL_VARIABLE) {
            return SuggestedFix.builder().build();
        }
        Optional<VariableTree> removedVariableTree = allUsageSites.stream().filter(tp -> tp.getLeaf() instanceof VariableTree).findFirst().map(tp -> (VariableTree)tp.getLeaf());
        Optional<AssignmentTree> reassignment = specs.stream().map(UnusedSpec::terminatingAssignment).filter(Optional::isPresent).map(Optional::get).filter(a -> allUsageSites.stream().noneMatch(tp -> tp.getLeaf().equals(a))).findFirst();
        if (!removedVariableTree.isPresent() || !reassignment.isPresent()) {
            return SuggestedFix.builder().build();
        }
        return SuggestedFix.prefixWith((Tree)reassignment.get(), (String)(state.getSourceForNode(removedVariableTree.get().getType()) + " "));
    }

    private static String describeVariable(Symbol.VarSymbol symbol) {
        switch (symbol.getKind()) {
            case FIELD: {
                return "field";
            }
            case LOCAL_VARIABLE: {
                return "local variable";
            }
            case PARAMETER: {
                return "parameter";
            }
        }
        return "variable";
    }

    private static boolean hasNativeMethods(CompilationUnitTree tree) {
        final AtomicBoolean hasAnyNativeMethods = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                    hasAnyNativeMethods.set(true);
                }
                return null;
            }
        }.scan(tree, null);
        return hasAnyNativeMethods.get();
    }

    private static boolean needsBlock(TreePath path) {
        Tree leaf = path.getLeaf();
        class Visitor
        extends SimpleTreeVisitor<Boolean, Void> {
            final /* synthetic */ Tree val$leaf;

            Visitor(Tree tree) {
                this.val$leaf = tree;
            }

            @Override
            public Boolean visitIf(IfTree tree, Void unused) {
                return tree.getThenStatement() == this.val$leaf || tree.getElseStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitDoWhileLoop(DoWhileLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitWhileLoop(WhileLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitForLoop(ForLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitEnhancedForLoop(EnhancedForLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }
        }
        return (Boolean)MoreObjects.firstNonNull((Object)path.getParentPath().getLeaf().accept(new Visitor(leaf), null), (Object)false);
    }

    private static ImmutableList<SuggestedFix> buildUnusedVarFixes(Symbol varSymbol, List<TreePath> usagePaths, VisitorState state) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Symbol)varSymbol, (String)"Inject")) {
            return ImmutableList.of();
        }
        ElementKind varKind = varSymbol.getKind();
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription("remove unused variable");
        for (TreePath usagePath : usagePaths) {
            StatementTree statement = (StatementTree)usagePath.getLeaf();
            if (statement.getKind() == Tree.Kind.VARIABLE) {
                if (ASTHelpers.getSymbol((Tree)statement).getKind() == ElementKind.PARAMETER) continue;
                VariableTree variableTree = (VariableTree)statement;
                ExpressionTree initializer = variableTree.getInitializer();
                if (SideEffectAnalysis.hasSideEffect((ExpressionTree)initializer) && TOP_LEVEL_EXPRESSIONS.contains((Object)initializer.getKind())) {
                    if (varKind == ElementKind.FIELD) {
                        String newContent = String.format("%s{ %s; }", varSymbol.isStatic() ? "static " : "", state.getSourceForNode((Tree)initializer));
                        fix.merge(SuggestedFixes.replaceIncludingComments((TreePath)usagePath, (String)newContent, (VisitorState)state));
                        continue;
                    }
                    fix.replace((Tree)statement, String.format("%s;", state.getSourceForNode((Tree)initializer)));
                    continue;
                }
                if (StrictUnusedVariable.isEnhancedForLoopVar(usagePath)) {
                    String modifiers = Strings.nullToEmpty(variableTree.getModifiers() == null ? null : state.getSourceForNode((Tree)variableTree.getModifiers()));
                    String newContent = String.format("%s%s unused", modifiers.isEmpty() ? "" : modifiers + " ", state.getSourceForNode(variableTree.getType()));
                    fix.replace((Tree)variableTree, newContent);
                    continue;
                }
                String replacement = StrictUnusedVariable.needsBlock(usagePath) ? "{}" : "";
                fix.merge(SuggestedFixes.replaceIncludingComments((TreePath)usagePath, (String)replacement, (VisitorState)state));
                continue;
            }
            if (statement.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                JCTree tree = (JCTree)((Object)((ExpressionStatementTree)statement).getExpression());
                if (tree instanceof CompoundAssignmentTree) {
                    if (SideEffectAnalysis.hasSideEffect((ExpressionTree)((CompoundAssignmentTree)((Object)tree)).getExpression())) {
                        SuggestedFix replacement = SuggestedFix.replace((int)tree.getStartPosition(), (int)((JCTree.JCAssignOp)tree).getExpression().getStartPosition(), (String)"");
                        fix.merge(replacement);
                        continue;
                    }
                } else if (tree instanceof AssignmentTree && SideEffectAnalysis.hasSideEffect((ExpressionTree)((AssignmentTree)((Object)tree)).getExpression())) {
                    fix.replace(tree.getStartPosition(), ((JCTree.JCAssign)tree).getExpression().getStartPosition(), "");
                    continue;
                }
            }
            String replacement = StrictUnusedVariable.needsBlock(usagePath) ? "{}" : "";
            fix.replace((Tree)statement, replacement);
        }
        return ImmutableList.of((Object)fix.build());
    }

    private static ImmutableList<SuggestedFix> buildUnusedLambdaParameterFix(Symbol.VarSymbol _symbol, Collection<UnusedSpec> values, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (UnusedSpec unusedSpec : values) {
            Tree leaf = unusedSpec.variableTree().getLeaf();
            if (!(leaf instanceof VariableTree)) continue;
            VariableTree tree = (VariableTree)leaf;
            if (state.getEndPosition(tree.getType()) == -1) {
                fix.replace((Tree)tree, "_" + tree.getName());
                continue;
            }
            int startPos = state.getEndPosition(tree.getType()) + 1;
            int endPos = state.getEndPosition((Tree)tree);
            fix.replace(startPos, endPos, "_" + tree.getName());
        }
        return ImmutableList.of((Object)fix.build());
    }

    private static ImmutableList<SuggestedFix> buildUnusedParameterFixes(Symbol varSymbol, final Symbol.MethodSymbol methodSymbol, List<TreePath> usagePaths, final VisitorState state) {
        boolean isPrivateMethod = methodSymbol.getModifiers().contains((Object)Modifier.PRIVATE);
        final int index = methodSymbol.params.indexOf(varSymbol);
        Preconditions.checkState((index != -1 ? 1 : 0) != 0, (String)"symbol %s must be a parameter to the owning method", (Object)varSymbol);
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        for (TreePath path : usagePaths) {
            fix.delete(path.getLeaf());
        }
        if (isPrivateMethod) {
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                    if (ASTHelpers.getSymbol((MethodInvocationTree)tree).equals(methodSymbol)) {
                        this.removeByIndex(tree.getArguments());
                    }
                    return (Void)super.visitMethodInvocation(tree, null);
                }

                @Override
                public Void visitMethod(MethodTree tree, Void unused) {
                    if (ASTHelpers.getSymbol((MethodTree)tree).equals(methodSymbol)) {
                        this.removeByIndex(tree.getParameters());
                    }
                    return (Void)super.visitMethod(tree, null);
                }

                private void removeByIndex(List<? extends Tree> trees) {
                    int endPos;
                    int startPos;
                    if (index >= trees.size()) {
                        return;
                    }
                    if (trees.size() == 1) {
                        Tree tree = (Tree)Iterables.getOnlyElement(trees);
                        if (((JCTree)tree).getStartPosition() == -1 || state.getEndPosition(tree) == -1) {
                            return;
                        }
                        fix.delete(tree);
                        return;
                    }
                    if (index >= 1) {
                        startPos = state.getEndPosition(trees.get(index - 1));
                        endPos = state.getEndPosition(trees.get(index));
                    } else {
                        startPos = ((JCTree)trees.get(index)).getStartPosition();
                        endPos = ((JCTree)trees.get(index + 1)).getStartPosition();
                    }
                    if (index == methodSymbol.params().size() - 1 && methodSymbol.isVarArgs()) {
                        endPos = state.getEndPosition((Tree)Iterables.getLast(trees));
                    }
                    if (startPos == -1 || endPos == -1) {
                        return;
                    }
                    fix.replace(startPos, endPos, "");
                }
            }.scan(state.getPath().getCompilationUnit(), null);
        } else {
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitMethod(MethodTree methodTree, Void unused) {
                    if (ASTHelpers.getSymbol((MethodTree)methodTree).equals(methodSymbol)) {
                        this.renameByIndex(methodTree.getParameters());
                    }
                    return (Void)super.visitMethod(methodTree, null);
                }

                private void renameByIndex(List<? extends VariableTree> trees) {
                    if (index >= trees.size()) {
                        return;
                    }
                    VariableTree tree = trees.get(index);
                    int startPos = state.getEndPosition(tree.getType()) + 1;
                    int endPos = state.getEndPosition((Tree)trees.get(index));
                    if (index == methodSymbol.params().size() - 1 && methodSymbol.isVarArgs()) {
                        endPos = state.getEndPosition((Tree)Iterables.getLast(trees));
                    }
                    if (startPos == -1 || endPos == -1) {
                        return;
                    }
                    String name = tree.getName().toString();
                    if (name.startsWith(StrictUnusedVariable.UNUSED)) {
                        fix.replace(startPos, endPos, "_" + (name.equals(StrictUnusedVariable.UNUSED) ? "value" : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name.substring(StrictUnusedVariable.UNUSED.length()))));
                    } else {
                        fix.replace(startPos, endPos, "_" + tree.getName());
                    }
                }
            }.scan(state.getPath().getCompilationUnit(), null);
        }
        return ImmutableList.of((Object)fix.build());
    }

    private static boolean isEnhancedForLoopVar(TreePath variablePath) {
        Tree tree = variablePath.getLeaf();
        Tree parent = variablePath.getParentPath().getLeaf();
        return parent instanceof EnhancedForLoopTree && ((EnhancedForLoopTree)parent).getVariable() == tree;
    }

    private static boolean exemptedByAnnotation(List<? extends AnnotationTree> annotations, VisitorState unused) {
        for (AnnotationTree annotationTree : annotations) {
            Symbol.TypeSymbol tsym;
            if (((JCTree.JCAnnotation)annotationTree).type == null || !EXEMPTING_VARIABLE_ANNOTATIONS.contains((Object)(tsym = ((JCTree.JCAnnotation)annotationTree).type.tsym).getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean exemptedByName(javax.lang.model.element.Name name) {
        return EXEMPT_PREFIXES.stream().anyMatch(prefix -> Ascii.toLowerCase((String)name.toString()).startsWith((String)prefix));
    }

    static interface UnusedSpec {
        public Symbol symbol();

        public TreePath variableTree();

        public ImmutableList<TreePath> usageSites();

        public Optional<AssignmentTree> terminatingAssignment();

        public static UnusedSpec of(final Symbol symbol, final TreePath variableTree, Iterable<TreePath> treePaths, final @Nullable AssignmentTree assignmentTree) {
            final ImmutableList treePaths1 = ImmutableList.copyOf(treePaths);
            return new UnusedSpec(){

                @Override
                public Symbol symbol() {
                    return symbol;
                }

                @Override
                public TreePath variableTree() {
                    return variableTree;
                }

                @Override
                public ImmutableList<TreePath> usageSites() {
                    return treePaths1;
                }

                @Override
                public Optional<AssignmentTree> terminatingAssignment() {
                    return Optional.ofNullable(assignmentTree);
                }
            };
        }
    }

    static class VariableUsage
    extends TreePathScanner<Void, Void> {
        public final ListMultimap<Symbol, TreePath> usageSites = ArrayListMultimap.create();

        VariableUsage() {
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            this.usageSites.put((Object)ASTHelpers.getSymbol((VariableTree)tree), (Object)this.getCurrentPath());
            return (Void)super.visitVariable(tree, null);
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void unused) {
            this.usageSites.put((Object)ASTHelpers.getSymbol((Tree)tree), (Object)this.getCurrentPath());
            return (Void)super.visitIdentifier(tree, null);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
            this.usageSites.put((Object)ASTHelpers.getSymbol((Tree)memberSelectTree), (Object)this.getCurrentPath());
            return (Void)super.visitMemberSelect(memberSelectTree, null);
        }
    }

    private static final class FilterUsedVariables
    extends TreePathScanner<Void, Void> {
        private boolean leftHandSideAssignment = false;
        private int inArrayAccess = 0;
        private boolean inReturnStatement = false;
        private int inMethodCall = 0;
        private final Set<Symbol> hasBeenAssigned = new HashSet<Symbol>();
        private TreePath currentExpressionStatement = null;
        private final Map<Symbol, TreePath> unusedElements;
        private final ListMultimap<Symbol, TreePath> usageSites;
        private final Set<Symbol> isEverUsed = new HashSet<Symbol>();
        private final List<UnusedSpec> unusedSpecs = new ArrayList<UnusedSpec>();
        private final ImmutableMap<Symbol, TreePath> declarationSites;

        private FilterUsedVariables(Map<Symbol, TreePath> unusedElements, ListMultimap<Symbol, TreePath> usageSites) {
            this.unusedElements = unusedElements;
            this.usageSites = usageSites;
            this.declarationSites = ImmutableMap.copyOf(unusedElements);
        }

        private boolean isInExpressionStatementTree() {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            return parent != null && parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        }

        private boolean isUsed(@Nullable Symbol symbol) {
            return symbol != null && (!this.leftHandSideAssignment || this.inReturnStatement || this.inArrayAccess > 0 || this.inMethodCall > 0) && this.unusedElements.containsKey(symbol);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
            if (this.hasBeenAssigned(tree, symbol)) {
                this.hasBeenAssigned.add(symbol);
            }
            return (Void)super.visitVariable(tree, null);
        }

        private boolean hasBeenAssigned(VariableTree tree, Symbol.VarSymbol symbol) {
            if (symbol == null) {
                return false;
            }
            if (symbol.getKind() == ElementKind.PARAMETER) {
                return true;
            }
            if (this.getCurrentPath().getParentPath().getLeaf() instanceof EnhancedForLoopTree) {
                return true;
            }
            return this.unusedElements.containsKey(symbol) && tree.getInitializer() != null;
        }

        @Override
        public Void visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
            this.currentExpressionStatement = this.getCurrentPath();
            super.visitExpressionStatement(tree, null);
            this.currentExpressionStatement = null;
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
            if (this.isUsed(symbol)) {
                this.unusedElements.remove(symbol);
            }
            if (this.currentExpressionStatement != null && this.unusedElements.containsKey(symbol)) {
                this.usageSites.put((Object)symbol, (Object)this.currentExpressionStatement);
            }
            return null;
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, Void unused) {
            this.scan(tree.getExpression(), null);
            if (this.isInExpressionStatementTree()) {
                this.handleReassignment(tree);
                this.leftHandSideAssignment = true;
                this.scan(tree.getVariable(), null);
                this.leftHandSideAssignment = false;
            } else {
                super.visitAssignment(tree, null);
            }
            return null;
        }

        private void handleReassignment(AssignmentTree tree) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (!(parent instanceof StatementTree)) {
                return;
            }
            if (tree.getVariable().getKind() != Tree.Kind.IDENTIFIER) {
                return;
            }
            if (ASTHelpers.findEnclosingNode((TreePath)this.getCurrentPath(), ForLoopTree.class) != null) {
                return;
            }
            Symbol symbol = ASTHelpers.getSymbol((Tree)tree.getVariable());
            if (!(this.hasBeenAssigned.contains(symbol) && symbol.getKind() == ElementKind.LOCAL_VARIABLE || symbol.getKind() == ElementKind.PARAMETER)) {
                return;
            }
            if (!this.declarationSites.containsKey((Object)symbol)) {
                return;
            }
            this.hasBeenAssigned.add(symbol);
            TreePath assignmentSite = (TreePath)this.declarationSites.get((Object)symbol);
            if (FilterUsedVariables.scopeDepth(assignmentSite) != Iterables.size((Iterable)this.getCurrentPath().getParentPath())) {
                return;
            }
            if (this.unusedElements.containsKey(symbol)) {
                this.unusedSpecs.add(UnusedSpec.of(symbol, assignmentSite, this.usageSites.get((Object)symbol), tree));
            } else {
                this.isEverUsed.add(symbol);
            }
            this.unusedElements.put(symbol, this.getCurrentPath());
            this.usageSites.removeAll((Object)symbol);
            this.usageSites.put((Object)symbol, (Object)this.getCurrentPath().getParentPath());
        }

        private static int scopeDepth(TreePath assignmentSite) {
            Symbol.VarSymbol symbol;
            if (assignmentSite.getParentPath().getLeaf() instanceof EnhancedForLoopTree) {
                return Iterables.size((Iterable)assignmentSite) + 1;
            }
            if (assignmentSite.getLeaf() instanceof VariableTree && (symbol = ASTHelpers.getSymbol((VariableTree)((VariableTree)assignmentSite.getLeaf()))).getKind() == ElementKind.PARAMETER) {
                return Iterables.size((Iterable)assignmentSite) + 1;
            }
            return Iterables.size((Iterable)assignmentSite);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol((Tree)memberSelectTree);
            if (this.isUsed(symbol)) {
                this.unusedElements.remove(symbol);
            } else if (this.currentExpressionStatement != null && this.unusedElements.containsKey(symbol)) {
                this.usageSites.put((Object)symbol, (Object)this.currentExpressionStatement);
            }
            boolean wasLeftHandAssignment = this.leftHandSideAssignment;
            this.leftHandSideAssignment = false;
            super.visitMemberSelect(memberSelectTree, null);
            this.leftHandSideAssignment = wasLeftHandAssignment;
            return null;
        }

        @Override
        public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
            super.visitMemberReference(tree, null);
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
            if (symbol != null) {
                symbol.getParameters().forEach(this.unusedElements::remove);
            }
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
            if (this.isInExpressionStatementTree()) {
                this.leftHandSideAssignment = true;
                this.scan(tree.getVariable(), null);
                this.leftHandSideAssignment = false;
                this.scan(tree.getExpression(), null);
            } else {
                super.visitCompoundAssignment(tree, null);
            }
            return null;
        }

        @Override
        public Void visitArrayAccess(ArrayAccessTree node, Void unused) {
            ++this.inArrayAccess;
            super.visitArrayAccess(node, null);
            --this.inArrayAccess;
            return null;
        }

        @Override
        public Void visitReturn(ReturnTree node, Void unused) {
            this.inReturnStatement = true;
            this.scan(node.getExpression(), null);
            this.inReturnStatement = false;
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree tree, Void unused) {
            if (this.isInExpressionStatementTree() && (tree.getKind() == Tree.Kind.POSTFIX_DECREMENT || tree.getKind() == Tree.Kind.POSTFIX_INCREMENT || tree.getKind() == Tree.Kind.PREFIX_DECREMENT || tree.getKind() == Tree.Kind.PREFIX_INCREMENT)) {
                this.leftHandSideAssignment = true;
                this.scan(tree.getExpression(), null);
                this.leftHandSideAssignment = false;
            } else {
                super.visitUnary(tree, null);
            }
            return null;
        }

        @Override
        public Void visitErroneous(ErroneousTree tree, Void unused) {
            return (Void)this.scan(tree.getErrorTrees(), null);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            ++this.inMethodCall;
            super.visitMethodInvocation(tree, null);
            --this.inMethodCall;
            return null;
        }
    }

    private final class VariableFinder
    extends TreePathScanner<Void, Void> {
        private final Map<Symbol, TreePath> unusedElements = new HashMap<Symbol, TreePath>();
        private final Set<Symbol> onlyCheckForReassignments = new HashSet<Symbol>();
        private final ListMultimap<Symbol, TreePath> usageSites = ArrayListMultimap.create();
        private final Map<Symbol, VariableTree> exemptedVariables = new HashMap<Symbol, VariableTree>();
        private final VisitorState state;

        private VariableFinder(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void unused) {
            if (StrictUnusedVariable.this.isSuppressed(variableTree)) {
                return null;
            }
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
            if (symbol == null) {
                return null;
            }
            if (StrictUnusedVariable.exemptedByName(variableTree.getName())) {
                this.exemptedVariables.put(symbol, variableTree);
                return null;
            }
            if (symbol.getKind() == ElementKind.FIELD && this.exemptedFieldBySuperType(ASTHelpers.getType((Tree)variableTree), this.state)) {
                return null;
            }
            super.visitVariable(variableTree, null);
            if (StrictUnusedVariable.exemptedByAnnotation(variableTree.getModifiers().getAnnotations(), this.state)) {
                return null;
            }
            switch (symbol.getKind()) {
                case FIELD: {
                    if (!this.isFieldEligibleForChecking(variableTree, symbol)) break;
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                    break;
                }
                case LOCAL_VARIABLE: {
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                    break;
                }
                case PARAMETER: {
                    if (variableTree.getName().contentEquals("this")) {
                        return null;
                    }
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    if (this.isParameterSubjectToAnalysis(symbol)) break;
                    this.onlyCheckForReassignments.add(symbol);
                    break;
                }
            }
            return null;
        }

        private boolean exemptedFieldBySuperType(Type type, VisitorState state) {
            return EXEMPTING_FIELD_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)state.getTypeFromString(t), (VisitorState)state));
        }

        private boolean isFieldEligibleForChecking(VariableTree variableTree, Symbol.VarSymbol symbol) {
            return variableTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE) && !SPECIAL_FIELDS.contains((Object)((Name)symbol.getSimpleName()).toString());
        }

        private boolean isParameterSubjectToAnalysis(Symbol sym) {
            Preconditions.checkArgument((sym.getKind() == ElementKind.PARAMETER ? 1 : 0) != 0);
            Symbol enclosingMethod = sym.owner;
            return !enclosingMethod.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        @Override
        public Void visitTry(TryTree node, Void unused) {
            this.scan(node.getBlock(), null);
            this.scan(node.getCatches(), null);
            this.scan(node.getFinallyBlock(), null);
            return null;
        }

        @Override
        public Void visitClass(ClassTree tree, Void unused) {
            if (StrictUnusedVariable.this.isSuppressed(tree)) {
                return null;
            }
            if (EXEMPTING_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((ClassTree)tree), (Type)((Type)Suppliers.typeFromString((String)t).get(this.state)), (VisitorState)this.state))) {
                return null;
            }
            return (Void)super.visitClass(tree, null);
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
            this.scan(node.getBody(), null);
            this.scan(node.getParameters(), null);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void unused) {
            if (this.state.getEndPosition((Tree)tree) < 0) {
                return null;
            }
            return StrictUnusedVariable.this.isSuppressed(tree) ? null : (Void)super.visitMethod(tree, unused);
        }
    }
}

