/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.Deque;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.Vector;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@BugPattern(name="StrictCollectionIncompatibleType", altNames={"SuspiciousMethodCalls", "CollectionIncompatibleType"}, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Likely programming error due to using incompatible types as arguments for a collection method that accepts Object.")
public final class StrictCollectionIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final String COLLECTION = Collection.class.getName();
    private static final String DEQUE = Deque.class.getName();
    private static final String DICTIONARY = Dictionary.class.getName();
    private static final String LIST = List.class.getName();
    private static final String MAP = Map.class.getName();
    private static final String STACK = Stack.class.getName();
    private static final String VECTOR = Vector.class.getName();
    private static final String FUNCTION = Function.class.getName();
    private static final String PREDICATE = Predicate.class.getName();
    private final ImmutableList<IncompatibleTypeMatcher> matchers = ImmutableList.of((Object)this.compatibleArgType(MAP, "containsKey(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(MAP, "containsValue(java.lang.Object)", 1, 0), (Object)this.compatibleArgType(MAP, "get(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(MAP, "getOrDefault(java.lang.Object,V)", 0, 0), (Object)this.compatibleArgType(MAP, "remove(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(COLLECTION, "contains(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(COLLECTION, "remove(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(DEQUE, "removeFirstOccurrence(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(DEQUE, "removeLastOccurrence(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(DICTIONARY, "get(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(DICTIONARY, "remove(java.lang.Object)", 0, 0), (Object)this.compatibleArgType(LIST, "indexOf(java.lang.Object)", 0, 0), (Object[])new IncompatibleTypeMatcher[]{this.compatibleArgType(LIST, "lastIndexOf(java.lang.Object)", 0, 0), this.compatibleArgType(STACK, "search(java.lang.Object)", 0, 0), this.compatibleArgType(VECTOR, "indexOf(java.lang.Object,int)", 0, 0), this.compatibleArgType(VECTOR, "lastIndexOf(java.lang.Object,int)", 0, 0), this.compatibleArgType(VECTOR, "removeElement(java.lang.Object)", 0, 0)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (int i = 0; i < this.matchers.size(); ++i) {
            IncompatibleTypeMatcher matcher = (IncompatibleTypeMatcher)this.matchers.get(i);
            Optional<Description> result = matcher.describe(tree, state);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        for (int i = 0; i < this.matchers.size(); ++i) {
            IncompatibleTypeMatcher matcher = (IncompatibleTypeMatcher)this.matchers.get(i);
            Optional<Description> result = matcher.describe(tree, state);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private static Type getBoxedResult(ExpressionTree expressionTree, VisitorState state) {
        Type rawType = ASTHelpers.getResultType((ExpressionTree)expressionTree);
        if (rawType == null) {
            return null;
        }
        return state.getTypes().boxedTypeOrType(rawType);
    }

    @Nullable
    private static Type getTargetTypeAsSuper(MethodInvocationTree tree, String superTarget, VisitorState state) {
        Type targetMapType = StrictCollectionIncompatibleType.getTargetType(tree);
        if (targetMapType == null) {
            return null;
        }
        Symbol mapSymbol = state.getSymbolFromString(superTarget);
        if (mapSymbol == null) {
            return null;
        }
        return state.getTypes().asSuper(targetMapType, mapSymbol);
    }

    @Nullable
    private static Type getTargetTypeAsSuper(MemberReferenceTree tree, String superTarget, VisitorState state) {
        ExpressionTree targetExpressionTree = tree.getQualifierExpression();
        if (targetExpressionTree == null) {
            return null;
        }
        Type targetMapType = ASTHelpers.getResultType((ExpressionTree)targetExpressionTree);
        if (targetMapType == null) {
            return null;
        }
        Symbol mapSymbol = state.getSymbolFromString(superTarget);
        if (mapSymbol == null) {
            return null;
        }
        return state.getTypes().asSuper(targetMapType, mapSymbol);
    }

    @Nullable
    private static Type getTargetType(MethodInvocationTree tree) {
        ExpressionTree methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)methodSelect;
            return ASTHelpers.getResultType((ExpressionTree)memberSelectTree.getExpression());
        }
        return null;
    }

    private IncompatibleTypeMatcher compatibleArgType(String baseType, String signature, int typeArgumentIndex, int argumentIndex) {
        MethodMatchers.MethodSignatureMatcher methodMatcher = MethodMatchers.instanceMethod().onDescendantOf(baseType).withSignature(signature);
        return new IncompatibleTypeMatcher((Matcher)methodMatcher, argumentIndex, baseType, typeArgumentIndex){
            final /* synthetic */ Matcher val$methodMatcher;
            final /* synthetic */ int val$argumentIndex;
            final /* synthetic */ String val$baseType;
            final /* synthetic */ int val$typeArgumentIndex;
            {
                this.val$methodMatcher = matcher;
                this.val$argumentIndex = n;
                this.val$baseType = string;
                this.val$typeArgumentIndex = n2;
            }

            @Override
            public Optional<Description> describe(MethodInvocationTree tree, VisitorState state) {
                if (!this.val$methodMatcher.matches((Tree)tree, state)) {
                    return Optional.empty();
                }
                if (tree.getArguments().size() <= this.val$argumentIndex) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                Type targetType = StrictCollectionIncompatibleType.getTargetTypeAsSuper(tree, this.val$baseType, state);
                if (targetType == null) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                if (targetType.getTypeArguments().size() <= this.val$typeArgumentIndex) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                Type typeArgumentType = targetType.getTypeArguments().get(this.val$typeArgumentIndex);
                ExpressionTree argumentTree = tree.getArguments().get(this.val$argumentIndex);
                Type argumentType = StrictCollectionIncompatibleType.getBoxedResult(argumentTree, state);
                if (argumentType == null) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                if (StrictCollectionIncompatibleType.typesCompatible(argumentType, typeArgumentType, state)) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                return Optional.of(StrictCollectionIncompatibleType.this.buildDescription(argumentTree).setMessage("Likely programming error due to using incompatible types as arguments for a collection method that accepts Object. Value '" + state.getSourceForNode((Tree)argumentTree) + "' of type '" + StrictCollectionIncompatibleType.prettyType(argumentType) + "' is not compatible with the expected type '" + StrictCollectionIncompatibleType.prettyType(typeArgumentType) + '\'').build());
            }

            @Override
            public Optional<Description> describe(MemberReferenceTree tree, VisitorState state) {
                if (!this.val$methodMatcher.matches((Tree)tree, state)) {
                    return Optional.empty();
                }
                if (tree.getMode() != MemberReferenceTree.ReferenceMode.INVOKE) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                Type targetType = StrictCollectionIncompatibleType.getTargetTypeAsSuper(tree, this.val$baseType, state);
                if (targetType == null) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                if (targetType.getTypeArguments().size() <= this.val$typeArgumentIndex) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                Type typeArgumentType = targetType.getTypeArguments().get(this.val$typeArgumentIndex);
                Type rawArgumentType = StrictCollectionIncompatibleType.getFunctionalInterfaceArgumentType(tree, this.val$argumentIndex, state);
                if (rawArgumentType == null) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                Type argumentType = state.getTypes().boxedTypeOrType(rawArgumentType);
                if (StrictCollectionIncompatibleType.typesCompatible(argumentType, typeArgumentType, state)) {
                    return IncompatibleTypeMatcher.NO_MATCH;
                }
                return Optional.of(StrictCollectionIncompatibleType.this.buildDescription(tree).setMessage("Likely programming error due to using incompatible types as arguments for a collection method that accepts Object. Type '" + StrictCollectionIncompatibleType.prettyType(argumentType) + "' is not compatible with the expected type '" + StrictCollectionIncompatibleType.prettyType(typeArgumentType) + '\'').build());
            }
        };
    }

    private static boolean typesCompatible(Type argumentType, Type typeArgumentType, VisitorState state) {
        return ASTHelpers.isSubtype((Type)argumentType, (Type)typeArgumentType, (VisitorState)state) || ASTHelpers.isSubtype((Type)typeArgumentType, (Type)argumentType, (VisitorState)state);
    }

    @Nullable
    private static Type getFunctionalInterfaceArgumentType(MemberReferenceTree tree, int argumentIndex, VisitorState state) {
        Type resultType = ASTHelpers.getResultType((ExpressionTree)tree);
        if (resultType == null) {
            return null;
        }
        if (!StrictCollectionIncompatibleType.isSupportedFunctionalInterface(resultType, state)) {
            return null;
        }
        if (resultType.getTypeArguments().size() <= argumentIndex) {
            return null;
        }
        return resultType.getTypeArguments().get(argumentIndex);
    }

    private static boolean isSupportedFunctionalInterface(Type type, VisitorState state) {
        return ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString(FUNCTION), (VisitorState)state) || ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString(PREDICATE), (VisitorState)state);
    }

    private static String prettyType(Type type) {
        return SuggestedFixes.prettyType(null, null, (Type)type);
    }

    private static interface IncompatibleTypeMatcher {
        public static final Optional<Description> NO_MATCH = Optional.of(Description.NO_MATCH);

        public Optional<Description> describe(MethodInvocationTree var1, VisitorState var2);

        public Optional<Description> describe(MemberReferenceTree var1, VisitorState var2);
    }
}

