/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Optional;

@BugPattern(name="GradleProviderToString", summary="Calling toString on a Provider does not render the contained value", severity=BugPattern.SeverityLevel.ERROR)
public final class GradleProviderToString
extends AbstractToString {
    private static final TypePredicate IS_PROVIDER = TypePredicates.isDescendantOf((String)"org.gradle.api.provider.Provider");

    protected TypePredicate typePredicate() {
        return IS_PROVIDER;
    }

    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return Optional.of(SuggestedFix.postfixWith((Tree)tree, (String)".get()"));
    }

    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree expression, VisitorState state) {
        return Optional.empty();
    }
}

