/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldEncoding;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\n\u00a2\u0006\u0004\b\u0017\u0010\u0011J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0016R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lcom/squareup/wire/ProtoWriter;", "", "Lokio/ByteString;", "value", "", "writeBytes", "(Lokio/ByteString;)V", "", "writeString", "(Ljava/lang/String;)V", "", "fieldNumber", "Lcom/squareup/wire/FieldEncoding;", "fieldEncoding", "writeTag", "(ILcom/squareup/wire/FieldEncoding;)V", "writeSignedVarint32$wire_runtime", "(I)V", "writeSignedVarint32", "writeVarint32", "", "writeVarint64", "(J)V", "writeFixed32", "writeFixed64", "Lokio/BufferedSink;", "sink", "Lokio/BufferedSink;", "<init>", "(Lokio/BufferedSink;)V", "Companion", "wire-runtime"})
public final class ProtoWriter {
    public static final Companion Companion = new Companion(null);
    private final BufferedSink sink;

    public ProtoWriter(@NotNull BufferedSink bufferedSink) {
        Intrinsics.checkParameterIsNotNull((Object)bufferedSink, (String)"sink");
        this.sink = bufferedSink;
    }

    public final void writeBytes(@NotNull ByteString byteString) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)byteString, (String)"value");
        this.sink.write(byteString);
    }

    public final void writeString(@NotNull String string) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"value");
        this.sink.writeUtf8(string);
    }

    public final void writeTag(int n2, @NotNull FieldEncoding fieldEncoding) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)fieldEncoding), (String)"fieldEncoding");
        this.writeVarint32(ProtoWriter.Companion.makeTag(n2, fieldEncoding));
    }

    public final void writeSignedVarint32$wire_runtime(int n2) throws IOException {
        if (n2 >= 0) {
            this.writeVarint32(n2);
        } else {
            this.writeVarint64(n2);
        }
    }

    public final void writeVarint32(int n2) throws IOException {
        while ((n2 & 0xFFFFFF80) != 0) {
            this.sink.writeByte(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
        this.sink.writeByte(n2);
    }

    public final void writeVarint64(long l2) throws IOException {
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.sink.writeByte((int)l2 & 0x7F | 0x80);
            l2 >>>= 7;
        }
        this.sink.writeByte((int)l2);
    }

    public final void writeFixed32(int n2) throws IOException {
        this.sink.writeIntLe(n2);
    }

    public final void writeFixed64(long l2) throws IOException {
        this.sink.writeLongLe(l2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\r\u0010\nJ\u0017\u0010\u0010\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000f\u0010\nJ\u0017\u0010\u0014\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0016\u0010\nJ\u0017\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0018\u0010\nJ\u0017\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001b\u00a8\u0006!"}, d2={"Lcom/squareup/wire/ProtoWriter$Companion;", "", "", "fieldNumber", "Lcom/squareup/wire/FieldEncoding;", "fieldEncoding", "makeTag", "(ILcom/squareup/wire/FieldEncoding;)I", "tag", "tagSize$wire_runtime", "(I)I", "tagSize", "value", "int32Size$wire_runtime", "int32Size", "varint32Size$wire_runtime", "varint32Size", "", "varint64Size$wire_runtime", "(J)I", "varint64Size", "n", "encodeZigZag32$wire_runtime", "encodeZigZag32", "decodeZigZag32$wire_runtime", "decodeZigZag32", "encodeZigZag64$wire_runtime", "(J)J", "encodeZigZag64", "decodeZigZag64$wire_runtime", "decodeZigZag64", "<init>", "()V", "wire-runtime"})
    public static final class Companion {
        private final int makeTag(int n2, FieldEncoding fieldEncoding) {
            return n2 << 3 | fieldEncoding.getValue$wire_runtime();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final int tagSize$wire_runtime(int n2) {
            Companion companion = this;
            return companion.varint32Size$wire_runtime(companion.makeTag(n2, FieldEncoding.VARINT));
        }

        public final int int32Size$wire_runtime(int n2) {
            return n2 >= 0 ? this.varint32Size$wire_runtime(n2) : 10;
        }

        public final int varint32Size$wire_runtime(int n2) {
            if ((n2 & 0xFFFFFF80) == 0) {
                return 1;
            }
            if ((n2 & 0xFFFFC000) == 0) {
                return 2;
            }
            if ((n2 & 0xFFE00000) == 0) {
                return 3;
            }
            return (n2 & 0xF0000000) == 0 ? 4 : 5;
        }

        public final int varint64Size$wire_runtime(long l2) {
            if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                return 1;
            }
            if ((l2 & 0xFFFFFFFFFFFFC000L) == 0L) {
                return 2;
            }
            if ((l2 & 0xFFFFFFFFFFE00000L) == 0L) {
                return 3;
            }
            if ((l2 & 0xFFFFFFFFF0000000L) == 0L) {
                return 4;
            }
            if ((l2 & 0xFFFFFFF800000000L) == 0L) {
                return 5;
            }
            if ((l2 & 0xFFFFFC0000000000L) == 0L) {
                return 6;
            }
            if ((l2 & 0xFFFE000000000000L) == 0L) {
                return 7;
            }
            if ((l2 & 0xFF00000000000000L) == 0L) {
                return 8;
            }
            return (l2 & Long.MIN_VALUE) == 0L ? 9 : 10;
        }

        public final int encodeZigZag32$wire_runtime(int n2) {
            return n2 << 1 ^ n2 >> 31;
        }

        public final int decodeZigZag32$wire_runtime(int n2) {
            return n2 >>> 1 ^ -(n2 & 1);
        }

        public final long encodeZigZag64$wire_runtime(long l2) {
            return l2 << 1 ^ l2 >> 63;
        }

        public final long decodeZigZag64$wire_runtime(long l2) {
            return l2 >>> 1 ^ -(l2 & 1L);
        }
    }
}

