package com.joyy.hagorpc.internal

import com.joyy.hagorpc.IRPCInternalContext
import com.joyy.hagorpc.IResCallback
import com.joyy.hagorpc.RPCCallException
import com.joyy.hagorpc.RPCCallResponse
import com.joyy.hagorpc.RPCPacketV2

/**
 * 长连接请求
 * Created by wjh on 2021/10/25
 */
class WsRequest private constructor() : RecyclableData() {

    companion object : RecyclablePool() {

        fun obtain(): WsRequest {
            val result = find()
            return if (result is WsRequest) {
                result
            } else {
                WsRequest()
            }
        }

        override fun getLock(): Any {
            return WsRequest.Companion
        }
    }

    var wsUrl: String? = null // 长连接请求地址
    var httpUrl: String? = null // 短连接请求地址

    var callback: IResCallback? = null // 回调

    // 请求协议
    var protocol: RPCPacketV2? = null

    // 与调用者沟通交互的接口
    var mContext: IRPCInternalContext? = null

    /**
     * 请求结果回调
     */
    fun callback(result: RPCCallResponse) {
        this.callback.let { callback ->
            // 回调结果的同时记得回收当前request
            if (callback == null) {
                recycle()
            } else {
                if (callback.callbackOnUI()) {
                    mContext?.getMainExecutor()?.execute(Runnable {
                        callback.onResponse(result)
                        recycle()
                    })
                } else {
                    callback.onResponse(result)
                    recycle()
                }
            }
        }
    }

    /**
     * 请求异常回调
     */
    fun callback(error: RPCCallException): Boolean {
        val wantRetry = this.callback?.onError(error) ?: false
        if (!wantRetry || !error.canRetry()) {
            // 如果上层不希望重试或当前不允许重试，则此次请求不再有必要，回收
            recycle()
        }
        return wantRetry
    }

    override fun handleRecycle() {
        wsUrl = null
        callback = null
        protocol = null
        mContext = null
    }

    override fun getPool(): RecyclablePool {
        return WsRequest.Companion
    }
}