package com.joyy.hagorpc.internal

import com.joyy.hagorpc.birdge.SystemBridge
import kotlin.jvm.Synchronized

object UniqueSeq {
    private var mSeq = SystemBridge.currentTimeMillis()

    @Synchronized
    fun uniqueSeq(): Long {
        val cur = SystemBridge.currentTimeMillis()
        if (cur > mSeq) {
            mSeq = cur
        } else {
            mSeq++
        }
        return mSeq
    }
}