package com.joyy.hagorpc.internal

import com.joyy.hagorpc.IRegisterId

/**
 * 广播监听绑定ID
 * Created by wjh on 2021/10/25
 */
class RegisterId(
    val service: String = "",
    val uri: Long? = null, val fullMatch: Boolean
) : IRegisterId {

    override fun isMatch(service: String, uri: Long): Boolean {
        return if (fullMatch) {
            if (this.service == service) {
                if (this.uri == null) {
                    true
                } else {
                    this.uri == uri
                }
            } else {
                false
            }
        } else {
            if (service.contains(this.service)) {
                if (this.uri == null) {
                    true
                } else {
                    this.uri == uri
                }
            } else {
                false
            }
        }
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is RegisterId) return false

        if (service != other.service) return false
        if (uri != other.uri) return false
        if (fullMatch != other.fullMatch) return false

        return true
    }

    override fun hashCode(): Int {
        var result = service.hashCode()
        result = 31 * result + (uri?.hashCode() ?: 0)
        result = 31 * result + fullMatch.hashCode()
        return result
    }
}