package com.joyy.hagorpc.internal

import com.joyy.hagorpc.RPCHeader
import com.joyy.hagorpc.RPCPacketV2
import com.joyy.hagorpc.RPCPacketV3
import com.joyy.hagorpc.internal.RPCHeaderExt.fromHeader
import com.joyy.hagorpc.internal.RPCHeaderExt.toHeader
import ikxd.cproxy.InnerV2
import ikxd.cproxy.InnerV3
import okio.ByteString.Companion.of

internal object RPCPacketExt {

    fun InnerV2.fromInnerV2(): RPCPacketV2 {
        return RPCPacketV2(
            header = header?.fromHeader() ?: RPCHeader.EMPTY,
            uri = uri ?: 0,
            payload = payload?.toByteArray() ?: ByteArrayExt.EMPTY
        )
    }

    fun RPCPacketV2.toInnerV2(): InnerV2 {
        return InnerV2.Builder()
            .uri(uri)
            .header(header.toHeader())
            .payload(of(*payload))
            .build()
    }

    fun InnerV3?.fromInnerV3(): RPCPacketV3? {
        if (this == null) return null
        return RPCPacketV3(
            seqId = seqid,
            msgType = msgtype,
            version = version,
            magic = magic,
            payload = payload.toByteArray()
        )
    }

}