package com.joyy.hagorpc.internal

import com.joyy.hagorpc.birdge.LocalPersistenceBridge

/**
 * rpc服务本地持久话帮助类
 * Created by wjh on 2021/10/26
 */
object RPCLocalPersistence {

    const val KEY_BROADCAST_SEQ = "reliable_broadcast_"
    const val KEY_ROUTING_KEY = "X_Routing_Key_"
    const val NAME_PERSISTENCE = "rpc_local_persistence"

    fun getBroadcastSeq(uid: String?, default: Long = 0): Long {
        return LocalPersistenceBridge.getLong(
            NAME_PERSISTENCE,
            KEY_BROADCAST_SEQ + (uid ?: ""),
            default
        ) ?: default
    }

    fun updateBroadcastSeq(uid: String?, value: Long) {
        LocalPersistenceBridge.putLong(NAME_PERSISTENCE, KEY_BROADCAST_SEQ + (uid ?: ""), value)
    }

    fun updateCProxyRouting(sname: String, key: String) {
        val lastKey =
            LocalPersistenceBridge.getString(NAME_PERSISTENCE, KEY_ROUTING_KEY + sname, "") ?: ""
        if (lastKey != key) {
            LocalPersistenceBridge.putString(NAME_PERSISTENCE, KEY_ROUTING_KEY + sname, key)
        }
    }

    fun getCProxyRouting(sname: String): String {
        return LocalPersistenceBridge.getString(NAME_PERSISTENCE, KEY_ROUTING_KEY + sname, "") ?: ""
    }
}