package com.joyy.hagorpc.internal

import com.joyy.hagorpc.RPCHeader
import com.joyy.hagorpc.fromValue
import common.Header
import okio.ByteString
import okio.ByteString.Companion.of

internal object RPCHeaderExt {

    fun Header.fromHeader(): RPCHeader {
        return RPCHeader(
            sname = sname ?: "",
            seqid = seqid ?: 0L,
            code = code ?: 0L,
            lang = lang ?: "",
            tid = tid ?: "",
            roomid = roomid ?: "",
            method = method ?: "",
            version = version ?: "",
            msgtype = msgtype.value.fromValue(),
            backGround = back_ground ?: false,
            biz = biz?.toByteArray() ?: ByteString.EMPTY.toByteArray(),
            extend = extend?.let {
                val result = mutableMapOf<String, ByteArray>()
                for ((key, value) in it) {
                    result[key] = value.toByteArray()
                }
                result
            } ?: emptyMap(),
            routingKey = routing_key?.toByteArray() ?: ByteString.EMPTY.toByteArray(),
            gameid = gameid ?: ""
        )
    }

    fun RPCHeader.toHeader(): Header {
        val result = mutableMapOf<String, ByteString>()
        for ((key, value) in extend) {
            result[key] = of(*value)
        }
        return Header.Builder()
            .sname(sname)
            .seqid(seqid)
            .code(code)
            .lang(lang)
            .tid(tid)
            .roomid(roomid)
            .method(method)
            .version(version)
            .msgtype(Header.MSGTYPE.fromValue(msgtype.value))
            .back_ground(backGround)
            .biz(biz?.let { of(*biz) })
            .extend(result)
            .routing_key(routingKey?.let { of(*routingKey) })
            .gameid(gameid)
            .build()
    }
}