package com.joyy.hagorpc.internal

internal object RPCConst {

    const val RPC_HTTP_API = "/ymicro/api"

    const val X_AUTH_TOKEN = "X-Auth-Token"
    const val X_DEVICE_ID = "X-DeviceId"
    const val X_SIM_CI_SO = "X-SimCIso"
    const val X_CLIENT_NET = "X-Client-Net"
    const val X_LANG = "X-Lang"
    const val X_YMICRO_API_SERVICE_NAME = "X-Ymicro-Api-Service-Name"
    const val X_YMICRO_API_METHOD_NAME = "X-Ymicro-Api-Method-Name"
    const val X_PCID = "X-Pcid"
    const val X_YMICRO_API_SERVICE_NAME_LOWER_CASE = "x-ymicro-api-service-name"
    const val X_YMICRO_API_METHOD_NAME_LOWER_CASE = "x-ymicro-api-method-name"
    const val X_ROUTE_KEY_NAME = "X-Routing-Key"
    const val X_ROOM_ID = "hago-room-id"

    const val DEFAULT_TASKS_POLLING: Long = 5000 // 默认轮序队列粒度粒度
    const val DEFAULT_TASK_TIMEOUT: Long = 10000 // 默认超时
    const val HEARTBEAT_TIMEOUT: Long = 10000 // 心跳超时
    const val CONNECT_RESEND_MAX_LIMIT = 20000 // connect连接成功后的重发的时间阀值
    const val INNERV3_MAGIC = 0x4861676eL // innerV3协议魔法数

    const val RELIABLE_BROADCAST = false // 广播是否可靠传输

    const val PING_INTERVAL = 20000L // ping的间隔时间
    const val CONNECT_RETRY_MAX = -1 // connect重试次数
    const val REQUEST_RETRY_MAX = 3 // request重试次数
    const val CONNECT_TIMEOUT = 30000L // connect超时时间

    const val RESEND_IF_CONNECTED = true // 如果已经连接，则重发
    const val PONG_TIMEOUT_NUM = 3 // 如果正在连接，则重发


}